/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import javax.swing.SwingUtilities;
import org.cytoscape.model.CyColumn;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableColumnTask;
import org.cytoscape.task.internal.table.DeleteColumnEdit;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public final class DeleteColumnTask
extends AbstractTableColumnTask
implements TunableValidator {
    private final CyServiceRegistrar serviceRegistrar;

    DeleteColumnTask(CyColumn column, CyServiceRegistrar serviceRegistrar) {
        super(column);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new DeleteColumnEdit(this.column));
        tm.setProgress(0.3);
        SwingUtilities.invokeLater(() -> this.column.getTable().deleteColumn(this.column.getName()));
        tm.setProgress(1.0);
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        if (this.column.isImmutable()) {
            try {
                errMsg.append("Cannot delete an immutable column.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        return TunableValidator.ValidationState.OK;
    }
}

