/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public class CreateTableTask
extends AbstractTableDataTask
implements ObservableTask {
    CyTable table;
    @Tunable(description="Table name (title)", context="nogui", longDescription="The name of the table used in the current network", exampleStringValue="Nodes")
    public String title = null;
    @Tunable(description="Key column name", context="nogui", longDescription="Specifies the name of a column in the table", exampleStringValue="Property")
    public String keyColumn = null;
    @Tunable(description="Type of key column", context="nogui", longDescription="The syntactical type of the value used in the key", exampleStringValue="Double")
    public ListSingleSelection<String> keyColumnType = new ListSingleSelection((Object[])new String[]{"integer", "long", "double", "string", "boolean"});

    public CreateTableTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        if (this.keyColumn == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Name of key column must be specified");
            return;
        }
        Class keyType = DataUtils.getType((String)this.keyColumnType.getSelectedValue());
        if (keyType == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Key column type must be specified");
            return;
        }
        if (this.title == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Table title must be specified");
            return;
        }
        this.table = ((CyTableFactory)this.serviceRegistrar.getService(CyTableFactory.class)).createTable(this.title, this.keyColumn, keyType, true, true);
        if (this.table != null) {
            tm.showMessage(TaskMonitor.Level.INFO, "Created table '" + this.table.toString() + "' (suid:" + this.table.getSUID() + ")");
            ((CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).addTable(this.table);
        } else {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to create table'" + this.title + "'");
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyTable.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(CyTable.class)) {
            return this.table;
        }
        if (requestedType.equals(String.class)) {
            return "" + this.table.getSUID();
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> "{\"table\":" + this.table.getSUID() + "}";
            return res;
        }
        return null;
    }
}

