/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.session;

import java.io.File;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.RecentlyOpenedTracker;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionSaveCancelledEvent;
import org.cytoscape.session.events.SessionSavedEvent;
import org.cytoscape.task.internal.session.CySessionWriter;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class SaveSessionAsTask
extends AbstractTask {
    @Tunable(description="Save Session as:", longDescription="The path name of the file where the current session must be saved to.", exampleStringValue="/Users/johndoe/Downloads/MySession.cys", required=true, params="fileCategory=session;input=false")
    public File file;
    private CySessionWriter writer;
    private final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return "Save Session";
    }

    public SaveSessionAsTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        CySession session = null;
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        try {
            tm.setProgress(0.05);
            session = ((CySessionManager)this.serviceRegistrar.getService(CySessionManager.class)).getCurrentSession();
            this.writer = new CySessionWriter(session, this.file, this.serviceRegistrar);
            this.writer.run(tm);
            tm.setProgress(1.0);
            if (!this.file.getName().endsWith(".cys")) {
                this.file = new File(this.file.getPath() + ".cys");
            }
        }
        catch (Exception e) {
            eventHelper.fireEvent((CyEvent)new SessionSaveCancelledEvent((Object)this));
            throw e;
        }
        if (!this.cancelled) {
            eventHelper.fireEvent((CyEvent)new SessionSavedEvent((Object)this, session, this.file.getAbsolutePath()));
            ((RecentlyOpenedTracker)this.serviceRegistrar.getService(RecentlyOpenedTracker.class)).add(this.file.toURI().toURL());
        }
    }

    public void cancel() {
        super.cancel();
        if (this.writer != null) {
            this.writer.cancel();
        }
        ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).fireEvent((CyEvent)new SessionSaveCancelledEvent((Object)this));
    }
}

