/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.HashSet;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.select.SelectionEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class SelectFirstNeighborsTask
extends AbstractSelectTask {
    private final CyEdge.Type direction;

    public SelectFirstNeighborsTask(CyNetwork net, CyEdge.Type direction, CyServiceRegistrar serviceRegistrar) {
        super(net, serviceRegistrar);
        this.direction = direction;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Select First Neighbors");
        tm.setProgress(0.0);
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        CyNetworkView view = this.getNetworkView(this.network);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new SelectionEdit("Select First-Neighbors", this.network, view, SelectionEdit.SelectionFilter.NODES_ONLY, this.serviceRegistrar));
        tm.setProgress(0.1);
        List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true);
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        tm.setProgress(0.2);
        for (CyNode currentNode : selectedNodes) {
            nodes.addAll(this.network.getNeighborList(currentNode, this.direction));
        }
        tm.setProgress(0.4);
        this.selectUtils.setSelectedNodes(this.network, nodes, true);
        tm.setProgress(0.8);
        this.updateView();
        tm.setProgress(1.0);
    }
}

