/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.select.SelectionEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class InvertSelectedNodesTask
extends AbstractSelectTask {
    public InvertSelectedNodesTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        super(net, serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Invert Node Selection");
        tm.setProgress(0.0);
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        CyNetworkView view = this.getNetworkView(this.network);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new SelectionEdit("Invert Selected Nodes", this.network, view, SelectionEdit.SelectionFilter.NODES_ONLY, this.serviceRegistrar));
        tm.setStatusMessage("Inverting Node Selection...");
        tm.setProgress(0.2);
        for (CyNode n : this.network.getNodeList()) {
            if (((Boolean)this.network.getRow((CyIdentifiable)n).get("selected", Boolean.class)).booleanValue()) {
                this.network.getRow((CyIdentifiable)n).set("selected", (Object)false);
                continue;
            }
            this.network.getRow((CyIdentifiable)n).set("selected", (Object)true);
        }
        tm.setStatusMessage("Updating View...");
        tm.setProgress(0.8);
        this.updateView();
        tm.setProgress(1.0);
    }
}

