/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.networkobjects.AbstractPropertyTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class ListPropertiesTask
extends AbstractPropertyTask
implements ObservableTask {
    Class<? extends CyIdentifiable> type;
    List<String> resultList;
    @Tunable(description="Network to get properties for", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;

    public ListPropertiesTask(Class<? extends CyIdentifiable> type, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.type = type;
    }

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "No network");
                return;
            }
        }
        this.resultList = this.listProperties(this.type, this.network);
        tm.showMessage(TaskMonitor.Level.INFO, "Properties for " + DataUtils.getIdentifiableType(this.type) + "s:");
        for (String prop : this.resultList) {
            tm.showMessage(TaskMonitor.Level.INFO, "     " + prop);
        }
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                StringBuilder stringBuilder = new StringBuilder("[");
                int count = this.resultList.size();
                for (String column : this.resultList) {
                    stringBuilder.append("\"" + column + "\"");
                    if (count > 1) {
                        stringBuilder.append(",");
                    }
                    --count;
                }
                stringBuilder.append("]");
                return stringBuilder.toString();
            };
            return res;
        }
        if (type.equals(String.class)) {
            StringBuilder stringBuilder = new StringBuilder("Properties for " + DataUtils.getIdentifiableType(type) + "s:");
            int count = this.resultList.size();
            for (String column : this.resultList) {
                stringBuilder.append("    " + column + "\n");
            }
            return stringBuilder.toString();
        }
        return this.resultList;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }
}

