/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.NodeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ListNodesTask
extends AbstractTask
implements ObservableTask {
    private final CyServiceRegistrar serviceRegistrar;
    List<CyNode> nodes;
    CyNetwork network;
    @ContainsTunables
    public NodeTunable nodeTunable;

    public ListNodesTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.nodeTunable = new NodeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        this.network = this.nodeTunable.getNetwork();
        this.nodes = this.nodeTunable.getNodeList();
        if (this.nodes == null || this.nodes.size() == 0) {
            tm.showMessage(TaskMonitor.Level.WARN, "No nodes found");
            return;
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Found " + this.nodes.size() + " nodes");
    }

    public Object getResults(Class type) {
        if (type.equals(List.class)) {
            return this.nodes;
        }
        if (type.equals(String.class)) {
            Object res = "";
            for (CyNode node : this.nodes) {
                res = (String)res + node.toString() + " [" + this.getName(this.network, node) + "]\n";
            }
            return ((String)res).substring(0, ((String)res).length() - 1);
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"nodes\":" + cyJSONUtil.cyIdentifiablesToJson(this.nodes) + "}";
            };
            return res;
        }
        return this.nodes;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyNode.class, String.class, JSONResult.class);
    }

    String getName(CyNetwork network, CyNode node) {
        return (String)network.getRow((CyIdentifiable)node).get("name", String.class);
    }
}

