/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.networkobjects.AbstractPropertyTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetNetworkPropertiesTask
extends AbstractPropertyTask
implements ObservableTask {
    Map<CyNetwork, Map<String, AbstractPropertyTask.VisualPropertyObjectTuple>> propertyMap = new HashMap<CyNetwork, Map<String, AbstractPropertyTask.VisualPropertyObjectTuple>>();
    @Tunable(description="Network to get properties for", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", required=true, context="nogui")
    public CyNetwork network;
    @Tunable(description="Properties to get the value for", longDescription="A comma-separated list of network properties", exampleStringValue="background paint,title", required=true, context="nogui")
    public String propertyList;

    public GetNetworkPropertiesTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        if (this.propertyList == null || this.propertyList.length() == 0) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Property list must be specified");
            throw new RuntimeException("Property list must be specified");
        }
        tm.showMessage(TaskMonitor.Level.INFO, "   Property values for network " + DataUtils.getNetworkName(this.network) + ":");
        String[] props = this.propertyList.split(",");
        HashMap<String, AbstractPropertyTask.VisualPropertyObjectTuple> pMap = new HashMap<String, AbstractPropertyTask.VisualPropertyObjectTuple>();
        for (String property : props) {
            try {
                VisualProperty<?> vp = this.getProperty(this.network, (CyIdentifiable)this.network, property.trim());
                Object value = this.getPropertyValue(this.network, (CyIdentifiable)this.network, vp);
                if (value == null) continue;
                tm.showMessage(TaskMonitor.Level.INFO, "        " + vp.getDisplayName() + "=" + value.toString());
                pMap.put(vp.getIdString(), new AbstractPropertyTask.VisualPropertyObjectTuple(vp, value));
            }
            catch (Exception e) {
                tm.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
                return;
            }
        }
        this.propertyMap.put(this.network, pMap);
    }

    public Object getResults(Class type) {
        if (type.equals(String.class)) {
            return DataUtils.convertMapToString(this.propertyMap);
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> GetNetworkPropertiesTask.getVisualPropertiesJSON(this.propertyMap);
            return res;
        }
        if (type.equals(Map.class)) {
            return this.propertyMap;
        }
        return this.propertyMap;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(Map.class, String.class, JSONResult.class);
    }
}

