/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.networkobjects.DeleteEdit;
import org.cytoscape.task.internal.utils.NodeAndEdgeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class DeleteSelectedNodesAndEdgesTask
extends AbstractTask
implements ObservableTask {
    private CyNetwork network;
    private final CyServiceRegistrar serviceRegistrar;
    private List<CyNode> selectedNodes;
    private Set<CyEdge> selectedEdges;
    @ContainsTunables
    public NodeAndEdgeTunable tunables;

    public DeleteSelectedNodesAndEdgesTask(CyNetwork network, CyServiceRegistrar serviceRegistrar) {
        this.network = network;
        this.serviceRegistrar = serviceRegistrar;
        this.tunables = new NodeAndEdgeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Remove Selected Nodes and Edges");
        tm.setProgress(0.0);
        List<CyNode> nodeList = this.tunables.getNodeList(false);
        List<CyEdge> edgeList = this.tunables.getEdgeList(false);
        if (this.tunables.getNetwork() != null) {
            this.network = this.tunables.getNetwork();
        }
        if (nodeList == null && edgeList == null) {
            this.selectedNodes = CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true);
            tm.setProgress(0.1);
            this.selectedEdges = new HashSet<CyEdge>(CyTableUtil.getEdgesInState((CyNetwork)this.network, (String)"selected", (boolean)true));
        } else {
            this.selectedNodes = nodeList != null && nodeList.size() > 0 ? nodeList : new ArrayList<CyNode>();
            this.selectedEdges = edgeList != null && edgeList.size() > 0 ? new HashSet<CyEdge>(edgeList) : new HashSet<CyEdge>();
        }
        tm.setProgress(0.2);
        for (CyNode selectedNode : this.selectedNodes) {
            this.selectedEdges.addAll(this.network.getAdjacentEdgeList(selectedNode, CyEdge.Type.ANY));
        }
        tm.setProgress(0.3);
        if (!this.selectedEdges.isEmpty() || !this.selectedNodes.isEmpty()) {
            UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
            CyNetworkViewManager netViewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
            CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
            undoSupport.postEdit((AbstractCyEdit)new DeleteEdit((CySubNetwork)this.network, this.selectedNodes, this.selectedEdges, netViewMgr, vmMgr, eventHelper));
            this.network.removeEdges(this.selectedEdges);
            tm.setProgress(0.7);
            this.network.removeNodes(this.selectedNodes);
            tm.setProgress(0.9);
            Collection views = netViewMgr.getNetworkViews(this.network);
            for (CyNetworkView netView : views) {
                netView.updateView();
            }
        }
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        ArrayList<Object> identifiables = new ArrayList<Object>();
        if (this.selectedNodes != null) {
            identifiables.addAll(this.selectedNodes);
        }
        if (this.selectedEdges != null) {
            identifiables.addAll(this.selectedEdges);
        }
        if (type.equals(List.class)) {
            return identifiables;
        }
        if (type.equals(String.class)) {
            if (identifiables.size() == 0) {
                return "<none>";
            }
            Object ret = "";
            if (this.selectedNodes != null && this.selectedNodes.size() > 0) {
                ret = (String)ret + "Nodes deleted: \n";
                for (CyNode node : this.selectedNodes) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)node).get("name", String.class) + "\n";
                }
            }
            if (this.selectedEdges != null && this.selectedEdges.size() > 0) {
                ret = (String)ret + "Edges deleted: \n";
                for (CyEdge edge : this.selectedEdges) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)edge).get("name", String.class) + "\n";
                }
            }
            return ret;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (identifiables == null || identifiables.size() == 0) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"nodes\":" + cyJSONUtil.cyIdentifiablesToJson(this.selectedNodes) + ", \"edges\":" + cyJSONUtil.cyIdentifiablesToJson(this.selectedEdges) + "}";
            };
            return res;
        }
        return identifiables;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }
}

