/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.NodeAndEdgeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class AddTask
extends AbstractTask
implements ObservableTask {
    final CyServiceRegistrar serviceRegistrar;
    final CyEventHelper eventHelper;
    @ContainsTunables
    public NodeAndEdgeTunable nodesAndEdges;
    List<CyNode> nodeList;
    List<CyEdge> edgeList;
    CyNetwork network;

    public AddTask(CyServiceRegistrar cyServiceRegistrar) {
        this.serviceRegistrar = cyServiceRegistrar;
        this.eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        this.nodesAndEdges = new NodeAndEdgeTunable(cyServiceRegistrar, true);
    }

    public void run(TaskMonitor taskMonitor) {
        this.network = this.nodesAndEdges.getNetwork();
        if (this.network == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Network must be specified for add command");
            return;
        }
        this.nodeList = this.nodesAndEdges.getNodeList(false);
        this.edgeList = this.nodesAndEdges.getEdgeList(false);
        if (!(this.nodeList != null && this.nodeList.size() != 0 || this.edgeList != null && this.edgeList.size() != 0)) {
            taskMonitor.showMessage(TaskMonitor.Level.WARN, "Nothing to add");
            return;
        }
        int nodeCount = this.nodeList.size();
        int edgeCount = 0;
        for (CyNode node : this.nodeList) {
            ((CySubNetwork)this.network).addNode(node);
        }
        for (CyEdge edge : this.edgeList) {
            if (!this.network.containsNode(edge.getSource()) || !this.network.containsNode(edge.getTarget())) continue;
            ((CySubNetwork)this.network).addEdge(edge);
            ++edgeCount;
        }
        this.eventHelper.flushPayloadEvents();
        taskMonitor.showMessage(TaskMonitor.Level.INFO, "Added " + nodeCount + " nodes and " + edgeCount + " edges to network " + this.network.toString());
    }

    public Object getResults(Class type) {
        ArrayList<Object> identifiables = new ArrayList<Object>();
        if (this.nodeList != null) {
            identifiables.addAll(this.nodeList);
        }
        if (this.edgeList != null) {
            identifiables.addAll(this.edgeList);
        }
        if (type.equals(List.class)) {
            return identifiables;
        }
        if (type.equals(String.class)) {
            if (identifiables.size() == 0) {
                return "<none>";
            }
            Object ret = "";
            if (this.nodeList != null && this.nodeList.size() > 0) {
                ret = (String)ret + "Nodes added: \n";
                for (CyNode node : this.nodeList) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)node).get("name", String.class) + "\n";
                }
            }
            if (this.edgeList != null && this.edgeList.size() > 0) {
                ret = (String)ret + "Edges added: \n";
                for (CyEdge edge : this.edgeList) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)edge).get("name", String.class) + "\n";
                }
            }
            return ret;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (identifiables == null || identifiables.size() == 0) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                Object result = "{\"nodes\":";
                result = this.nodeList == null || this.nodeList.size() == 0 ? (String)result + "[]" : (String)result + cyJSONUtil.cyIdentifiablesToJson(this.nodeList);
                result = (String)result + ", \"edges\":";
                result = this.edgeList == null || this.edgeList.size() == 0 ? (String)result + "[]" : (String)result + cyJSONUtil.cyIdentifiablesToJson(this.edgeList);
                result = (String)result + "}";
                return result;
            };
            return res;
        }
        return identifiables;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }
}

