/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class AddNodeTask
extends AbstractTask
implements ObservableTask {
    private CyNode newNode;
    private final CyServiceRegistrar serviceRegistrar;
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="Name of the node to add", longDescription="The name of the node, which will be assigned to both the 'name' and 'shared name' columns", exampleStringValue="Node 1", context="nogui")
    public String name;

    public AddNodeTask(CyServiceRegistrar registrar) {
        this.serviceRegistrar = registrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Add Node");
        tm.setProgress(0.0);
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified for add command");
                return;
            }
        }
        this.newNode = this.network.addNode();
        if (this.name != null) {
            this.network.getRow((CyIdentifiable)this.newNode).set("name", (Object)this.name);
            this.network.getRow((CyIdentifiable)this.newNode).set("shared name", (Object)this.name);
        }
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        CyNetworkViewManager networkViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        VisualMappingManager visualMappingManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        eventHelper.flushPayloadEvents();
        if (networkViewManager.viewExists(this.network)) {
            for (CyNetworkView view : networkViewManager.getNetworkViews(this.network)) {
                View nodeView = view.getNodeView(this.newNode);
                VisualStyle style = visualMappingManager.getVisualStyle(view);
                if (style == null) continue;
                style.apply(this.network.getRow((CyIdentifiable)this.newNode), nodeView);
            }
        }
        eventHelper.flushPayloadEvents();
        tm.showMessage(TaskMonitor.Level.INFO, "Added node " + this.newNode.toString() + " to network");
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        if (type.equals(CyNode.class)) {
            return this.newNode;
        }
        if (type.equals(String.class)) {
            if (this.newNode == null) {
                return "<none>";
            }
            return this.newNode.toString();
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.newNode == null) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"node\":" + cyJSONUtil.toJson((CyIdentifiable)this.newNode) + "}";
            };
            return res;
        }
        return this.newNode;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyNode.class, String.class, JSONResult.class);
    }
}

