/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class AddEdgeTask
extends AbstractTask
implements ObservableTask {
    private CyEdge newEdge;
    private final CyServiceRegistrar serviceRegistrar;
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="Name of edge source node", longDescription="Enter the name of an existing node in the network to be the source of the edge.  Note that this is the name as defined in the 'name' column of the network", exampleStringValue="Node 1", context="nogui", required=true)
    public String sourceName;
    @Tunable(description="Name of edge target node", longDescription="Enter the name of an existing node in the network to be the target of the edge.  Note that this is the name as defined in the 'name' column of the network", exampleStringValue="Node 2", context="nogui", required=true)
    public String targetName;
    @Tunable(description="Is the edge directed?", longDescription="Whether the edge should be directed or not.  Even though all edges in Cytoscape have a source and target, by default they are treated as undirected.  Setting this to 'true' will flag some algorithms to treat them as directed, although many current implementations will ignore this flag.", exampleStringValue="false", context="nogui")
    public boolean isDirected = false;
    @Tunable(description="Name of the edge to add", longDescription="Set the 'name' and 'shared name' columns for this edge to the provided value.", exampleStringValue="Sample Edge", context="nogui")
    public String name;

    public AddEdgeTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified for add command");
                return;
            }
        }
        if (this.sourceName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Source node name must be specified for add command");
            return;
        }
        if (this.targetName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Target node name must be specified for add command");
            return;
        }
        CyNode source = null;
        CyNode target = null;
        for (CyNode node : this.network.getNodeList()) {
            String nodeName = (String)this.network.getRow((CyIdentifiable)node).get("name", String.class);
            if (this.sourceName.equals(nodeName)) {
                source = node;
            } else if (this.targetName.equals(nodeName)) {
                target = node;
            }
            if (source == null || target == null) continue;
            break;
        }
        if (source == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find source node named '" + this.sourceName + "'");
            return;
        }
        if (target == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find target node named '" + this.targetName + "'");
            return;
        }
        this.newEdge = this.network.addEdge(source, target, this.isDirected);
        if (this.name != null) {
            this.network.getRow((CyIdentifiable)this.newEdge).set("name", (Object)this.name);
            this.network.getRow((CyIdentifiable)this.newEdge).set("shared name", (Object)this.name);
        }
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        CyNetworkViewManager networkViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        VisualMappingManager visualMappingManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        eventHelper.flushPayloadEvents();
        if (networkViewManager.viewExists(this.network)) {
            for (CyNetworkView view : networkViewManager.getNetworkViews(this.network)) {
                View edgeView = view.getEdgeView(this.newEdge);
                VisualStyle style = visualMappingManager.getVisualStyle(view);
                if (style != null) {
                    style.apply(this.network.getRow((CyIdentifiable)this.newEdge), edgeView);
                }
                view.updateView();
            }
        }
        eventHelper.flushPayloadEvents();
        tm.showMessage(TaskMonitor.Level.INFO, "Added edge " + this.newEdge.toString() + " to network");
    }

    public Object getResults(Class type) {
        if (type.equals(CyEdge.class)) {
            return this.newEdge;
        }
        if (type.equals(String.class)) {
            if (this.newEdge == null) {
                return "<none>";
            }
            return this.newEdge.toString();
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.newEdge == null) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"edge\":" + cyJSONUtil.toJson((CyIdentifiable)this.newEdge) + "}";
            };
            return res;
        }
        return this.newEdge;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyEdge.class, String.class, JSONResult.class);
    }
}

