/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.work.AbstractTask;

public abstract class AbstractPropertyTask
extends AbstractTask {
    protected final CyServiceRegistrar serviceRegistrar;

    protected AbstractPropertyTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public VisualProperty<?> getProperty(CyNetwork network, CyIdentifiable target, String propertyName) {
        Class<? extends CyIdentifiable> type = DataUtils.getIdentifiableClass(target);
        if (!((String)propertyName).startsWith(DataUtils.getIdentifiableType(type))) {
            propertyName = DataUtils.getIdentifiableType(type) + " " + (String)propertyName;
        }
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        RenderingEngineManager reManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
        Collection views = viewManager.getNetworkViews(network);
        for (CyNetworkView view : views) {
            for (RenderingEngine rEngine : reManager.getRenderingEngines((View)view)) {
                VisualLexicon lex = rEngine.getVisualLexicon();
                Set vProps = lex.getAllVisualProperties();
                for (VisualProperty prop : vProps) {
                    if (!((String)propertyName).equalsIgnoreCase(prop.getDisplayName())) continue;
                    return prop;
                }
            }
        }
        throw new RuntimeException("Property " + (String)propertyName + " doesn't exist");
    }

    public static String getVisualPropertyJSON(VisualProperty<Object> vp, Object object) {
        StringBuilder output = new StringBuilder("{\n");
        output.append("   \"visualProperty\":\"" + vp.getIdString() + "\",\n");
        output.append("   \"value\":");
        Class type = vp.getRange().getType();
        if (type == String.class) {
            output.append("\"" + object.toString() + "\"");
        } else if (type == Boolean.class || type == Double.class || type == Integer.class || type == Long.class || type == Float.class) {
            output.append(object.toString());
        } else {
            output.append("\"" + vp.toSerializableString(object) + "\"");
        }
        output.append("\n}");
        return output.toString();
    }

    protected static String getVisualPropertiesJSON(Map<? extends CyIdentifiable, Map<String, VisualPropertyObjectTuple>> map) {
        StringBuilder output = new StringBuilder("[\n");
        int count = map.size();
        for (Map.Entry<? extends CyIdentifiable, Map<String, VisualPropertyObjectTuple>> entry : map.entrySet()) {
            output.append("   {\"SUID\":" + entry.getKey().getSUID() + ",\n");
            output.append("    \"visualProperties\": [");
            int count2 = entry.getValue().size();
            for (Map.Entry<String, VisualPropertyObjectTuple> entry2 : entry.getValue().entrySet()) {
                output.append(AbstractPropertyTask.getVisualPropertyJSON(entry2.getValue().visualProperty, entry2.getValue().object).replace("   ", "         "));
                if (count2 > 1) {
                    output.append(",");
                }
                output.append("\n");
                --count2;
            }
            output.append("      ]");
            output.append("   }\n");
            if (count > 1) {
                output.append(",");
            }
            output.append("\n");
            --count;
        }
        output.append("]\n");
        return output.toString();
    }

    public Object getPropertyValue(CyNetwork network, CyIdentifiable target, VisualProperty vp) {
        CyNetworkView networkView = this.getViewForNetwork(network);
        Class vpTargetType = vp.getTargetDataType();
        if (target instanceof CyNetwork) {
            if (vpTargetType != CyNetwork.class) {
                throw new RuntimeException("Property '" + vp.getDisplayName() + "' not available for networks");
            }
            return networkView.getVisualProperty(vp);
        }
        if (target instanceof CyNode) {
            if (vpTargetType != CyNode.class) {
                throw new RuntimeException("Property '" + vp.getDisplayName() + "' not available for nodes");
            }
            View nodeView = networkView.getNodeView((CyNode)target);
            return nodeView.getVisualProperty(vp);
        }
        if (target instanceof CyEdge) {
            if (vpTargetType != CyEdge.class) {
                throw new RuntimeException("Property '" + vp.getDisplayName() + "' not available for edges");
            }
            View edgeView = networkView.getEdgeView((CyEdge)target);
            return edgeView.getVisualProperty(vp);
        }
        return null;
    }

    public Object getStringPropertyValue(CyNetwork network, CyIdentifiable target, VisualProperty vp) {
        Object v = this.getPropertyValue(network, target, vp);
        return vp.toSerializableString(v);
    }

    public void setPropertyValue(CyNetwork network, CyIdentifiable target, VisualProperty vp, String value) {
        this.setPropertyValue(network, target, vp, value, false);
    }

    public void setPropertyValue(CyNetwork network, CyIdentifiable target, VisualProperty vp, String value, boolean locked) {
        CyNetworkView networkView = this.getViewForNetwork(network);
        Class vpTargetType = vp.getTargetDataType();
        if (target instanceof CyNetwork) {
            if (vpTargetType != CyNetwork.class) {
                throw new RuntimeException("Property '" + vp.getDisplayName() + "' not available for networks");
            }
            Object t = vp.parseSerializableString(value);
            if (locked) {
                networkView.setLockedValue(vp, t);
            } else {
                if (networkView.isValueLocked(vp)) {
                    networkView.clearValueLock(vp);
                }
                networkView.setVisualProperty(vp, t);
            }
        } else if (target instanceof CyNode) {
            if (vpTargetType != CyNode.class) {
                throw new RuntimeException("Property '" + vp.getDisplayName() + "' not available for nodes");
            }
            View nodeView = networkView.getNodeView((CyNode)target);
            Object t = vp.parseSerializableString(value);
            if (locked) {
                nodeView.setLockedValue(vp, t);
            } else {
                if (nodeView.isValueLocked(vp)) {
                    nodeView.clearValueLock(vp);
                }
                nodeView.setVisualProperty(vp, t);
            }
        } else if (target instanceof CyEdge) {
            if (vpTargetType != CyEdge.class) {
                throw new RuntimeException("Property '" + vp.getDisplayName() + "' not available for edges");
            }
            View edgeView = networkView.getEdgeView((CyEdge)target);
            Object t = vp.parseSerializableString(value);
            if (locked) {
                edgeView.setLockedValue(vp, t);
            } else {
                if (edgeView.isValueLocked(vp)) {
                    edgeView.clearValueLock(vp);
                }
                edgeView.setVisualProperty(vp, t);
            }
        }
    }

    public List<String> listProperties(Class<? extends CyIdentifiable> type, CyNetwork network) {
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        RenderingEngineManager reManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
        Collection views = viewManager.getNetworkViews(network);
        ArrayList<String> propertyList = new ArrayList<String>();
        for (CyNetworkView view : views) {
            Iterator iterator = reManager.getRenderingEngines((View)view).iterator();
            if (!iterator.hasNext()) continue;
            RenderingEngine rEngine = (RenderingEngine)iterator.next();
            VisualLexicon lex = rEngine.getVisualLexicon();
            for (VisualProperty vp : lex.getAllVisualProperties()) {
                if (!vp.getTargetDataType().equals(type)) continue;
                String s = vp.getDisplayName();
                int x = s.indexOf(32);
                propertyList.add(s.substring(x + 1));
            }
            return propertyList;
        }
        return null;
    }

    private CyNetworkView getViewForNetwork(CyNetwork network) {
        CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        Collection views = viewManager.getNetworkViews(network);
        if (views == null || views.size() == 0) {
            return null;
        }
        Iterator iterator = views.iterator();
        if (iterator.hasNext()) {
            CyNetworkView view = (CyNetworkView)iterator.next();
            return view;
        }
        return null;
    }

    protected class VisualPropertyObjectTuple {
        public VisualProperty<Object> visualProperty;
        public Object object;

        public VisualPropertyObjectTuple(VisualProperty<Object> visualProperty, Object object) {
            this.visualProperty = visualProperty;
            this.object = object;
        }
    }
}

