/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class RegisterNetworkTask
extends AbstractTask
implements ObservableTask {
    private final List<CyNetwork> networks;
    private final List<CyNetworkView> views;
    private final VisualStyle style;
    private final boolean singleton;
    private final CyServiceRegistrar serviceRegistrar;

    public RegisterNetworkTask(CyNetwork network, CyServiceRegistrar serviceRegistrar) {
        this.networks = Collections.singletonList(network);
        this.views = null;
        this.style = null;
        this.singleton = true;
        this.serviceRegistrar = serviceRegistrar;
    }

    public RegisterNetworkTask(CyNetworkView view, VisualStyle style, CyServiceRegistrar serviceRegistrar) {
        this.networks = Collections.singletonList((CyNetwork)view.getModel());
        this.views = Collections.singletonList(view);
        this.style = style;
        this.singleton = true;
        this.serviceRegistrar = serviceRegistrar;
    }

    public RegisterNetworkTask(List<CyNetworkView> views, VisualStyle style, CyServiceRegistrar serviceRegistrar) {
        this.views = views;
        this.networks = new ArrayList<CyNetwork>();
        for (CyNetworkView view : views) {
            this.networks.add((CyNetwork)view.getModel());
        }
        this.style = style;
        this.singleton = false;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Register Networks");
        tm.setStatusMessage("Registering " + this.networks.size() + " network(s)...");
        tm.setProgress(0.0);
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        for (CyNetwork net : this.networks) {
            if (this.cancelled) {
                return;
            }
            if (netManager.networkExists(net.getSUID().longValue())) continue;
            netManager.addNetwork(net, false);
        }
        tm.setProgress(0.4);
        if (this.views != null && !this.views.isEmpty()) {
            tm.setStatusMessage("Registering " + this.views.size() + " view(s)...");
            CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            VisualMappingManager visMapManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
            for (CyNetworkView view : this.views) {
                if (this.cancelled) {
                    return;
                }
                if (view == null) continue;
                netViewManager.addNetworkView(view, false);
                tm.setProgress(0.2);
                if (this.style != null) {
                    visMapManager.setVisualStyle(this.style, view);
                    this.style.apply(view);
                    tm.setProgress(0.8);
                }
                view.updateView();
            }
        }
        if (this.cancelled) {
            return;
        }
        tm.setProgress(0.9);
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        if (this.views != null && !this.views.isEmpty()) {
            applicationManager.setCurrentNetworkView(this.views.get(0));
            applicationManager.setSelectedNetworkViews(this.views);
        } else {
            applicationManager.setCurrentNetwork(this.networks.get(0));
        }
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        if (type.equals(List.class)) {
            return this.views;
        }
        if (type.equals(String.class)) {
            if (this.networks == null) {
                return null;
            }
            Object res = "";
            if (this.views != null && this.views.size() > 0) {
                res = (String)res + "Views:\n";
                for (CyNetworkView view : this.views) {
                    res = (String)res + "    " + DataUtils.getViewTitle(view) + " (SUID: " + view.getSUID() + ")\n";
                }
            }
            res = (String)res + "Networks:\n";
            for (CyNetwork net : this.networks) {
                res = (String)res + "    " + DataUtils.getNetworkName(net) + " (SUID: " + net.getSUID() + ")\n";
            }
            return res;
        }
        if (type.equals(CyNetwork.class)) {
            return this.networks.get(0);
        }
        if (type.equals(CyNetworkView.class)) {
            if (this.views != null && this.views.size() > 0) {
                return this.views.get(0);
            }
            return null;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.networks == null) {
                    return "{}";
                }
                if (this.singleton) {
                    CyNetwork network = this.networks.get(0);
                    CyNetworkView view = null;
                    if (this.views != null && this.views.size() == 1) {
                        view = this.views.get(0);
                    }
                    return this.jsonNetView(network, view);
                }
                Object strRes = "[";
                HashSet<CyNetwork> viewNets = new HashSet<CyNetwork>();
                boolean first = true;
                for (CyNetworkView view : this.views) {
                    CyNetwork net = (CyNetwork)view.getModel();
                    viewNets.add(net);
                    if (!first) {
                        strRes = (String)strRes + ",";
                    } else {
                        first = false;
                    }
                    strRes = (String)strRes + this.jsonNetView(net, view);
                }
                for (CyNetwork net : this.networks) {
                    if (viewNets.contains(net)) continue;
                    strRes = (String)strRes + this.jsonNetView(net, null);
                }
                strRes = (String)strRes + "]";
                return strRes;
            };
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, CyNetworkView.class, CyNetwork.class, String.class, JSONResult.class);
    }

    private String jsonNetView(CyNetwork net, CyNetworkView view) {
        if (net == null) {
            return null;
        }
        if (view == null) {
            return "{\"network\":" + net.getSUID() + "}";
        }
        return "{\"network\":" + net.getSUID() + ",\"view\":" + view.getSUID() + "}";
    }
}

