/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.network;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public class NewEmptyNetworkTask
extends AbstractTask
implements ObservableTask {
    private CyNetworkView view;
    private CySubNetwork subNetwork;
    private final CyServiceRegistrar serviceRegistrar;
    public static final String CRERATE_NEW_COLLECTION_STRING = " -- Create new network collection --";
    public ListSingleSelection<String> rootNetworkList;
    @Tunable(description="Network Name:", longDescription="Enter the name of the new network.", exampleStringValue="My New Network", gravity=2.0)
    public String name = "Network";
    @Tunable(description="Network View Renderer:", longDescription="Select the renderer to use for the new network view.  By default, the standard Cytoscape 2D renderer (Ding) will be used", exampleStringValue="Cytoscape 2D", gravity=3.0)
    public ListSingleSelection<NetworkViewRenderer> renderers;
    protected HashMap<String, CyRootNetwork> name2RootMap;

    @Tunable(description="Network Collection:", longDescription="Choose the network collection the new network should be part of. If no network collection is selected, a new network collection is created.", exampleStringValue="network name", gravity=1.0)
    public ListSingleSelection<String> getRootNetworkList() {
        return this.rootNetworkList;
    }

    public void setRootNetworkList(ListSingleSelection<String> roots) {
        this.rootNetworkList = roots;
    }

    @ProvidesTitle
    public String getTitle() {
        return "Create New Network ";
    }

    public NewEmptyNetworkTask(Set<NetworkViewRenderer> viewRenderers, CyServiceRegistrar serviceRegistrar) {
        CyApplicationManager applicationMgr;
        List selectedNetworks;
        this.serviceRegistrar = serviceRegistrar;
        this.name2RootMap = this.getRootNetworkMap();
        ArrayList<String> rootNames = new ArrayList<String>();
        rootNames.addAll(this.name2RootMap.keySet());
        if (!rootNames.isEmpty()) {
            this.sort(rootNames);
            rootNames.add(0, CRERATE_NEW_COLLECTION_STRING);
        }
        this.rootNetworkList = new ListSingleSelection(rootNames);
        if (!rootNames.isEmpty()) {
            this.rootNetworkList.setSelectedValue((Object)((String)rootNames.get(0)));
        }
        if ((selectedNetworks = (applicationMgr = (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworks()) != null && selectedNetworks.size() > 0) {
            CyNetwork selectedNetwork = (CyNetwork)applicationMgr.getSelectedNetworks().get(0);
            String rootName = "";
            if (selectedNetwork instanceof CySubNetwork) {
                CySubNetwork subNet = (CySubNetwork)selectedNetwork;
                CyRootNetwork rootNet = subNet.getRootNetwork();
                rootName = (String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class);
            } else {
                rootName = (String)selectedNetwork.getRow((CyIdentifiable)selectedNetwork).get("name", String.class);
            }
            this.rootNetworkList.setSelectedValue((Object)rootName);
        }
        if (viewRenderers.size() > 1) {
            this.renderers = new ListSingleSelection(new ArrayList<NetworkViewRenderer>(viewRenderers));
            NetworkViewRenderer defViewRenderer = applicationMgr.getDefaultNetworkViewRenderer();
            if (defViewRenderer != null && viewRenderers.contains(defViewRenderer)) {
                this.renderers.setSelectedValue((Object)defViewRenderer);
            }
        } else {
            this.renderers = new ListSingleSelection(Collections.EMPTY_LIST);
        }
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("New Empty Network");
        tm.setProgress(0.0);
        CyNetworkViewManager viewMgr = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        VisualMappingManager visMapMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        VisualStyle style = visMapMgr.getDefaultVisualStyle();
        String networkCollectionName = (String)this.rootNetworkList.getSelectedValue();
        if (networkCollectionName == null || networkCollectionName.equalsIgnoreCase(CRERATE_NEW_COLLECTION_STRING)) {
            CyNetworkFactory netFactory = (CyNetworkFactory)this.serviceRegistrar.getService(CyNetworkFactory.class);
            this.subNetwork = (CySubNetwork)netFactory.createNetwork();
        } else {
            CyRootNetwork rootNet = this.name2RootMap.get(networkCollectionName);
            Collection baseViewSet = viewMgr.getNetworkViews((CyNetwork)rootNet.getBaseNetwork());
            this.subNetwork = rootNet.addSubNetwork();
            if (!baseViewSet.isEmpty()) {
                style = visMapMgr.getVisualStyle((CyNetworkView)baseViewSet.iterator().next());
            }
        }
        tm.setProgress(0.2);
        String networkName = ((CyNetworkNaming)this.serviceRegistrar.getService(CyNetworkNaming.class)).getSuggestedNetworkTitle(this.name);
        this.subNetwork.getRow((CyIdentifiable)this.subNetwork).set("name", (Object)networkName);
        if (networkCollectionName == null || networkCollectionName.equalsIgnoreCase(CRERATE_NEW_COLLECTION_STRING)) {
            CyRootNetwork rootNetwork = this.subNetwork.getRootNetwork();
            rootNetwork.getRow((CyIdentifiable)rootNetwork).set("name", (Object)networkName);
        }
        NetworkViewRenderer nvRenderer = null;
        try {
            nvRenderer = (NetworkViewRenderer)this.renderers.getSelectedValue();
        }
        catch (ClassCastException cce) {
            tm.showMessage(TaskMonitor.Level.WARN, "Unknown renderer: " + this.renderers.getSelectedValue() + " using default renderer.");
        }
        CyApplicationManager applicationMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        if (nvRenderer == null) {
            nvRenderer = applicationMgr.getDefaultNetworkViewRenderer();
        }
        CyNetworkViewFactory netViewFactory = nvRenderer.getNetworkViewFactory();
        tm.setProgress(0.4);
        this.view = netViewFactory.createNetworkView((CyNetwork)this.subNetwork);
        tm.setProgress(0.6);
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        netMgr.addNetwork((CyNetwork)this.subNetwork, false);
        applicationMgr.setCurrentNetwork((CyNetwork)this.subNetwork);
        tm.setProgress(0.8);
        viewMgr.addNetworkView(this.view);
        tm.setProgress(0.9);
        if (style != null) {
            visMapMgr.setVisualStyle(style, this.view);
        }
        tm.setProgress(1.0);
    }

    public CyNetworkView getView() {
        return this.view;
    }

    public HashMap<String, CyRootNetwork> getRootNetworkMap() {
        HashMap<String, CyRootNetwork> name2RootMap = new HashMap<String, CyRootNetwork>();
        CyNetworkManager netMgr = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        CyRootNetworkManager rootNetMgr = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
        for (CyNetwork net : netMgr.getNetworkSet()) {
            CyRootNetwork rootNet = rootNetMgr.getRootNetwork(net);
            if (name2RootMap.containsValue(rootNet)) continue;
            name2RootMap.put((String)rootNet.getRow((CyIdentifiable)rootNet).get("name", String.class), rootNet);
        }
        return name2RootMap;
    }

    private void sort(List<String> names) {
        if (!names.isEmpty()) {
            final Collator collator = Collator.getInstance(Locale.getDefault());
            Collections.sort(names, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1 == null && s2 == null) {
                        return 0;
                    }
                    if (s1 == null) {
                        return -1;
                    }
                    if (s2 == null) {
                        return 1;
                    }
                    return collator.compare(s1, s2);
                }
            });
        }
    }

    public Object getResults(Class type) {
        if (type.equals(CyNetwork.class)) {
            return this.subNetwork;
        }
        if (type.equals(String.class)) {
            if (this.subNetwork == null) {
                return "Network not created";
            }
            return "Created new empty network " + this.subNetwork.toString();
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.subNetwork == null) {
                    return "{}";
                }
                return "{\"network\":" + this.subNetwork.getSUID() + "}";
            };
            return res;
        }
        return this.subNetwork;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyNetwork.class, String.class, JSONResult.class);
    }
}

