/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.network;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.cytoscape.task.internal.network.AbstractCreationTask;
import org.cytoscape.task.internal.network.GroupUtils;
import org.cytoscape.task.internal.network.RegisterNetworkTask;
import org.cytoscape.task.internal.view.CopyExistingViewTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class CloneNetworkTask
extends AbstractCreationTask {
    private Map<CyNode, CyNode> orig2NewNodeMap;
    private Map<CyNode, CyNode> new2OrigNodeMap;
    private Map<CyEdge, CyEdge> new2OrigEdgeMap;
    private Map<CyEdge, CyEdge> orig2NewEdgeMap;
    private final VisualMappingManager visMapManager;
    private final CyNetworkFactory netFactory;
    private final CyNetworkViewFactory viewFactory;
    private final CyNetworkViewFactory nullViewFactory;
    private final CyNetworkNaming netNaming;
    private final CyNetworkManager netManager;
    private final CyNetworkViewManager viewManager;
    private final CyNetworkTableManager netTableManager;
    private final CyRootNetworkManager rootNetManager;
    private final CyGroupManager groupManager;
    private final CyGroupFactory groupFactory;
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="Clone View", context="nogui", longDescription="Whether or not to clone the network view as well. Only boolean values are allowed: ```true``` (default) or ```false```\"", exampleStringValue="true")
    public boolean cloneView = true;
    private CyNetworkView result;

    public CloneNetworkTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        super(net, serviceRegistrar);
        this.visMapManager = (VisualMappingManager)serviceRegistrar.getService(VisualMappingManager.class);
        this.netFactory = (CyNetworkFactory)serviceRegistrar.getService(CyNetworkFactory.class);
        this.viewFactory = (CyNetworkViewFactory)serviceRegistrar.getService(CyNetworkViewFactory.class);
        this.nullViewFactory = (CyNetworkViewFactory)serviceRegistrar.getService(CyNetworkViewFactory.class, "(id=NullCyNetworkViewFactory)");
        this.netNaming = (CyNetworkNaming)serviceRegistrar.getService(CyNetworkNaming.class);
        this.netManager = (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class);
        this.viewManager = (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class);
        this.netTableManager = (CyNetworkTableManager)serviceRegistrar.getService(CyNetworkTableManager.class);
        this.rootNetManager = (CyRootNetworkManager)serviceRegistrar.getService(CyRootNetworkManager.class);
        this.groupManager = (CyGroupManager)serviceRegistrar.getService(CyGroupManager.class);
        this.groupFactory = (CyGroupFactory)serviceRegistrar.getService(CyGroupFactory.class);
    }

    public void run(TaskMonitor tm) {
        CyNetworkView origView;
        tm.setTitle("Clone Network");
        tm.setStatusMessage("Cloning network...");
        tm.setProgress(0.0);
        if (this.network != null) {
            this.parentNetwork = this.network;
        }
        if (this.parentNetwork == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "No network to clone");
            return;
        }
        CyNetwork newNet = this.cloneNetwork(this.parentNetwork);
        tm.setProgress(0.5);
        Collection views = this.viewManager.getNetworkViews(this.parentNetwork);
        CyNetworkView cyNetworkView = origView = views.size() != 0 ? (CyNetworkView)views.iterator().next() : null;
        if (this.cloneView && origView != null && !this.cancelled) {
            tm.setStatusMessage("Cloning view...");
            VisualStyle style = this.visMapManager.getVisualStyle(origView);
            CyNetworkView newView = this.viewFactory.createNetworkView(newNet);
            tm.setProgress(0.6);
            if (!this.cancelled) {
                CopyExistingViewTask copyExistingViewTask = new CopyExistingViewTask(newView, origView, style, this.new2OrigNodeMap, this.new2OrigEdgeMap, false, this.serviceRegistrar);
                RegisterNetworkTask registerNetworkTask = new RegisterNetworkTask(newView, style, this.serviceRegistrar);
                this.insertTasksAfterCurrentTask(new Task[]{copyExistingViewTask, registerNetworkTask});
            }
        } else if (!this.cancelled) {
            RegisterNetworkTask registerNetworkTask = new RegisterNetworkTask(newNet, this.serviceRegistrar);
            this.insertTasksAfterCurrentTask(new Task[]{registerNetworkTask});
            this.result = this.nullViewFactory.createNetworkView(newNet);
        }
        if (this.cancelled) {
            this.dispose(newNet);
            return;
        }
        tm.setProgress(1.0);
    }

    private CyNetwork cloneNetwork(CyNetwork origNet) {
        CyNetwork newNet = this.netFactory.createNetwork(origNet.getSavePolicy());
        if (this.cancelled) {
            return newNet;
        }
        this.addColumns(origNet, newNet, CyNetwork.class, "LOCAL_ATTRS");
        this.addColumns(origNet, newNet, CyNode.class, "LOCAL_ATTRS");
        if (this.cancelled) {
            return newNet;
        }
        this.addColumns(origNet, newNet, CyEdge.class, "LOCAL_ATTRS");
        if (this.cancelled) {
            return newNet;
        }
        CyRootNetwork origRoot = this.rootNetManager.getRootNetwork(origNet);
        CyRootNetwork newRoot = this.rootNetManager.getRootNetwork(newNet);
        this.addColumns((CyNetwork)origRoot, (CyNetwork)newRoot, CyNetwork.class, "LOCAL_ATTRS");
        if (this.cancelled) {
            return newNet;
        }
        this.addColumns((CyNetwork)origRoot, (CyNetwork)newRoot, CyNode.class, "LOCAL_ATTRS");
        if (this.cancelled) {
            return newNet;
        }
        this.addColumns((CyNetwork)origRoot, (CyNetwork)newRoot, CyEdge.class, "LOCAL_ATTRS");
        if (this.cancelled) {
            return newNet;
        }
        this.cloneNodes(origNet, newNet);
        if (this.cancelled) {
            return newNet;
        }
        this.cloneEdges(origNet, newNet);
        if (this.cancelled) {
            return newNet;
        }
        this.cloneGroups(origNet, newNet);
        if (this.cancelled) {
            return newNet;
        }
        this.cloneNetwork(origNet, newNet);
        newNet.getRow((CyIdentifiable)newNet).set("name", (Object)this.netNaming.getSuggestedNetworkTitle((String)origNet.getRow((CyIdentifiable)origNet).get("name", String.class)));
        return newNet;
    }

    private void cloneNodes(CyNetwork origNet, CyNetwork newNet) {
        this.orig2NewNodeMap = new WeakHashMap<CyNode, CyNode>();
        this.new2OrigNodeMap = new WeakHashMap<CyNode, CyNode>();
        for (CyNode origNode : origNet.getNodeList()) {
            if (this.cancelled) {
                return;
            }
            this.cloneNode(origNet, newNet, origNode);
        }
    }

    private CyNode cloneNode(CyNetwork origNet, CyNetwork newNet, CyNode origNode) {
        if (this.orig2NewNodeMap.containsKey(origNode)) {
            return this.orig2NewNodeMap.get(origNode);
        }
        CyNode newNode = newNet.addNode();
        this.orig2NewNodeMap.put(origNode, newNode);
        this.new2OrigNodeMap.put(newNode, origNode);
        this.cloneRow(newNet, CyNode.class, origNet.getRow((CyIdentifiable)origNode, "LOCAL_ATTRS"), newNet.getRow((CyIdentifiable)newNode, "LOCAL_ATTRS"));
        this.cloneRow(newNet, CyNode.class, origNet.getRow((CyIdentifiable)origNode, "HIDDEN"), newNet.getRow((CyIdentifiable)newNode, "HIDDEN"));
        if (!this.groupManager.isGroup(origNode, origNet)) {
            this.cloneNetworkPointer(origNet, newNet, newNode, origNode.getNetworkPointer());
        }
        return newNode;
    }

    private void cloneEdges(CyNetwork origNet, CyNetwork newNet) {
        this.new2OrigEdgeMap = new WeakHashMap<CyEdge, CyEdge>();
        this.orig2NewEdgeMap = new WeakHashMap<CyEdge, CyEdge>();
        for (CyEdge origEdge : origNet.getEdgeList()) {
            if (this.cancelled) {
                return;
            }
            this.cloneEdge(origNet, newNet, origEdge);
        }
    }

    private CyEdge cloneEdge(CyNetwork origNet, CyNetwork newNet, CyEdge origEdge) {
        if (this.orig2NewEdgeMap.containsKey(origEdge)) {
            return this.orig2NewEdgeMap.get(origEdge);
        }
        CyNode newSource = this.orig2NewNodeMap.get(origEdge.getSource());
        CyNode newTarget = this.orig2NewNodeMap.get(origEdge.getTarget());
        boolean newDirected = origEdge.isDirected();
        CyEdge newEdge = newNet.addEdge(newSource, newTarget, newDirected);
        this.new2OrigEdgeMap.put(newEdge, origEdge);
        this.orig2NewEdgeMap.put(origEdge, newEdge);
        this.cloneRow(newNet, CyEdge.class, origNet.getRow((CyIdentifiable)origEdge, "LOCAL_ATTRS"), newNet.getRow((CyIdentifiable)newEdge, "LOCAL_ATTRS"));
        this.cloneRow(newNet, CyEdge.class, origNet.getRow((CyIdentifiable)origEdge, "HIDDEN"), newNet.getRow((CyIdentifiable)newEdge, "HIDDEN"));
        return newEdge;
    }

    private void cloneNetworkPointer(CyNetwork origNet, CyNetwork newNet, CyNode newNode, CyNetwork netPointer) {
        if (netPointer != null) {
            if (origNet.equals(netPointer)) {
                netPointer = newNet;
            }
            newNode.setNetworkPointer(netPointer);
        }
    }

    private void cloneGroups(CyNetwork origNet, CyNetwork newNet) {
        Set origGroups = this.groupManager.getGroupSet(origNet);
        for (CyGroup origGroup : origGroups) {
            if (this.cancelled) {
                return;
            }
            if (!origGroup.isCollapsed(origNet)) continue;
            for (CyNode origNode : origGroup.getNodeList()) {
                if (this.cancelled) {
                    return;
                }
                ((CySubNetwork)origNet).addNode(origNode);
                this.cloneNode(origNet, newNet, origNode);
            }
        }
        for (CyGroup origGroup : origGroups) {
            if (this.cancelled) {
                return;
            }
            this.cloneGroup(origNet, newNet, origGroup);
        }
    }

    private CyGroup cloneGroup(CyNetwork origNet, CyNetwork newNet, CyGroup origGroup) {
        ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
        boolean groupNodeExists = origNet.containsNode(origGroup.getGroupNode());
        boolean collapsed = origGroup.isCollapsed(origNet);
        if (collapsed) {
            origGroup.expand(origNet);
        } else {
            CyNode groupNode = origGroup.getGroupNode();
            if (!groupNodeExists) {
                ((CySubNetwork)origNet).addNode(groupNode);
                this.cloneNode(origNet, newNet, groupNode);
                ((CySubNetwork)origNet).removeNodes(Collections.singletonList(groupNode));
            }
        }
        for (CyNode node : origGroup.getNodeList()) {
            nodeList.add(this.orig2NewNodeMap.get(node));
        }
        for (CyEdge iEdge : origGroup.getInternalEdgeList()) {
            this.cloneEdge(origNet, newNet, iEdge);
        }
        for (CyEdge eEdge : origGroup.getExternalEdgeList()) {
            this.cloneEdge(origNet, newNet, eEdge);
        }
        CyNode newNode = this.orig2NewNodeMap.get(origGroup.getGroupNode());
        this.cloneMetaEdgeInfo(origNet, newNet, origGroup);
        CyGroup newGroup = this.groupFactory.createGroup(newNet, newNode, nodeList, null, true);
        this.cloneGroupTables(origNet, newNet, origGroup, newGroup);
        if (!groupNodeExists) {
            newNet.removeNodes(Collections.singletonList(newNode));
        }
        if (collapsed) {
            origGroup.collapse(origNet);
            newGroup.collapse(newNet);
        }
        return newGroup;
    }

    private void cloneMetaEdgeInfo(CyNetwork origNet, CyNetwork newNet, CyGroup origGroup) {
        CyRootNetwork origRoot = ((CySubNetwork)origNet).getRootNetwork();
        for (CyEdge edge : origRoot.getAdjacentEdgeList(origGroup.getGroupNode(), CyEdge.Type.ANY)) {
            GroupUtils.updateMetaEdgeInformation(origNet, newNet, edge, this.orig2NewEdgeMap.get(edge));
        }
    }

    private void cloneGroupTables(CyNetwork origNet, CyNetwork newNet, CyGroup origGroup, CyGroup newGroup) {
        CyNetwork origGroupNet = origGroup.getGroupNetwork();
        CyNetwork newGroupNet = newGroup.getGroupNetwork();
        this.addColumns(origGroupNet, newGroupNet, CyNetwork.class, "HIDDEN");
        this.addColumns(origGroupNet, newGroupNet, CyNode.class, "HIDDEN");
        Long groupNetworkSUID = origGroupNet.getSUID();
        Dimension d = GroupUtils.getPosition(origNet, origGroup, groupNetworkSUID, CyNetwork.class);
        if (d != null) {
            GroupUtils.initializePositions(newNet, newGroup, groupNetworkSUID, CyNetwork.class);
            GroupUtils.updatePosition(newNet, newGroup, groupNetworkSUID, CyNetwork.class, d);
        }
        for (CyNode node : origGroup.getNodeList()) {
            Long nodeSUID = node.getSUID();
            d = GroupUtils.getPosition(origNet, origGroup, nodeSUID, CyNode.class);
            if (d == null) continue;
            GroupUtils.initializePositions(newNet, newGroup, this.orig2NewNodeMap.get(node).getSUID(), CyNode.class);
            GroupUtils.updatePosition(newNet, newGroup, this.orig2NewNodeMap.get(node).getSUID(), CyNode.class, d);
        }
    }

    private void cloneNetwork(CyNetwork origNet, CyNetwork newNet) {
        this.cloneRow(newNet, CyNetwork.class, origNet.getRow((CyIdentifiable)origNet, "LOCAL_ATTRS"), newNet.getRow((CyIdentifiable)newNet, "LOCAL_ATTRS"));
    }

    private void addColumns(CyNetwork origNet, CyNetwork newNet, Class<? extends CyIdentifiable> tableType, String namespace) {
        CyTable from = origNet.getTable(tableType, namespace);
        CyTable to = newNet.getTable(tableType, namespace);
        CyRootNetwork origRoot = this.rootNetManager.getRootNetwork(origNet);
        CyRootNetwork newRoot = this.rootNetManager.getRootNetwork(newNet);
        Map origRootTables = this.netTableManager.getTables((CyNetwork)origRoot, tableType);
        for (CyColumn col : from.getColumns()) {
            if (this.cancelled) {
                return;
            }
            String name = col.getName();
            if (to.getColumn(name) != null) continue;
            VirtualColumnInfo info = col.getVirtualColumnInfo();
            if (info.isVirtual()) {
                if (origRootTables.containsValue(info.getSourceTable())) {
                    CyColumn origCol = info.getSourceTable().getColumn(info.getSourceColumn());
                    String sourceNamespace = this.netTableManager.getTableNamespace(info.getSourceTable());
                    CyTable newRootTable = newRoot.getTable(tableType, sourceNamespace);
                    if (newRootTable.getColumn(origCol.getName()) == null) {
                        this.copyColumn(origCol, newRootTable);
                    }
                    to.addVirtualColumn(name, origCol.getName(), newRootTable, "SUID", col.isImmutable());
                    continue;
                }
                this.addVirtualColumn(col, to);
                continue;
            }
            this.copyColumn(col, to);
        }
    }

    private void addVirtualColumn(CyColumn col, CyTable subTable) {
        VirtualColumnInfo colInfo = col.getVirtualColumnInfo();
        CyColumn checkCol = subTable.getColumn(col.getName());
        if (checkCol == null) {
            subTable.addVirtualColumn(col.getName(), colInfo.getSourceColumn(), colInfo.getSourceTable(), colInfo.getTargetJoinKey(), true);
        } else if (!(checkCol.getVirtualColumnInfo().isVirtual() && checkCol.getVirtualColumnInfo().getSourceTable().equals(colInfo.getSourceTable()) && checkCol.getVirtualColumnInfo().getSourceColumn().equals(colInfo.getSourceColumn()))) {
            subTable.addVirtualColumn(col.getName(), colInfo.getSourceColumn(), colInfo.getSourceTable(), colInfo.getTargetJoinKey(), true);
        }
    }

    private void copyColumn(CyColumn col, CyTable subTable) {
        CyColumn checkCol = subTable.getColumn(col.getName());
        if (checkCol == null) {
            if (List.class.isAssignableFrom(col.getType())) {
                subTable.createListColumn(col.getName(), col.getListElementType(), false);
            } else {
                subTable.createColumn(col.getName(), col.getType(), false);
            }
        }
    }

    private void cloneRow(CyNetwork newNet, Class<? extends CyIdentifiable> tableType, CyRow from, CyRow to) {
        CyRootNetwork newRoot = this.rootNetManager.getRootNetwork(newNet);
        Map rootTables = this.netTableManager.getTables((CyNetwork)newRoot, tableType);
        for (CyColumn col : to.getTable().getColumns()) {
            VirtualColumnInfo info;
            String name = col.getName();
            if (name.equals("SUID") || (info = col.getVirtualColumnInfo()).isVirtual() && !rootTables.containsValue(info.getSourceTable())) continue;
            to.set(name, from.getRaw(name));
        }
    }

    private void dispose(CyNetwork net) {
        if (this.netManager.networkExists(net.getSUID().longValue())) {
            this.netManager.destroyNetwork(net);
        } else {
            net.dispose();
        }
    }
}

