/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.hide;

import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.task.internal.hide.UnHideTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class UnHideFromSelectionTask
extends AbstractNetworkViewTask {
    private final String description;
    private final boolean unhideNodes;
    private final boolean unhideEdges;
    private final boolean justSelected;
    private final CyServiceRegistrar serviceRegistrar;

    public UnHideFromSelectionTask(String description, boolean unhideNodes, boolean unhideEdges, boolean justSelected, CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        super(view);
        this.description = description;
        this.unhideNodes = unhideNodes;
        this.unhideEdges = unhideEdges;
        this.justSelected = justSelected;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Show All Nodes and Edges");
        tm.setProgress(0.0);
        CyNetwork network = (CyNetwork)this.view.getModel();
        List nodes = null;
        List edges = null;
        if (this.unhideNodes) {
            nodes = this.justSelected ? CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true) : network.getNodeList();
        }
        tm.setProgress(0.1);
        if (this.unhideEdges) {
            edges = this.justSelected ? CyTableUtil.getEdgesInState((CyNetwork)network, (String)"selected", (boolean)true) : network.getEdgeList();
        }
        UnHideTask unHideTask = new UnHideTask(this.description, nodes, edges, this.view, this.serviceRegistrar);
        this.insertTasksAfterCurrentTask(new Task[]{unHideTask});
    }
}

