/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.hide;

import java.util.Collection;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

abstract class HideUtils {
    HideUtils() {
    }

    static void setVisibleNodes(Collection<CyNode> nodes, boolean visible, CyNetworkView view) {
        CyNetwork net = (CyNetwork)view.getModel();
        for (CyNode n : nodes) {
            if (visible) {
                view.getNodeView(n).clearValueLock(BasicVisualLexicon.NODE_VISIBLE);
            } else {
                ((CyNetwork)view.getModel()).getRow((CyIdentifiable)n).set("selected", (Object)false);
                view.getNodeView(n).setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)false);
            }
            for (CyNode n2 : net.getNeighborList(n, CyEdge.Type.ANY)) {
                for (CyEdge e : net.getConnectingEdgeList(n, n2, CyEdge.Type.ANY)) {
                    View ev = view.getEdgeView(e);
                    if (visible) {
                        ev.clearValueLock(BasicVisualLexicon.EDGE_VISIBLE);
                        continue;
                    }
                    ((CyNetwork)view.getModel()).getRow((CyIdentifiable)ev.getModel()).set("selected", (Object)false);
                    ev.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)false);
                }
            }
        }
    }

    static void setVisibleEdges(Collection<CyEdge> edges, boolean visible, CyNetworkView view) {
        for (CyEdge e : edges) {
            View ev = view.getEdgeView(e);
            if (visible) {
                ev.clearValueLock(BasicVisualLexicon.EDGE_VISIBLE);
                continue;
            }
            ev.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)false);
            ((CyNetwork)view.getModel()).getRow((CyIdentifiable)ev.getModel()).set("selected", (Object)false);
        }
    }
}

