/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.hide;

import java.util.ArrayList;
import java.util.Collection;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.task.internal.hide.HideEdit;
import org.cytoscape.task.internal.hide.HideUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class HideTask
extends AbstractNetworkViewTask {
    private final String description;
    private final Collection<CyNode> nodes;
    private final Collection<CyEdge> edges;
    private final CyServiceRegistrar serviceRegistrar;

    public HideTask(String description, Collection<CyNode> nodes, Collection<CyEdge> edges, CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        super(view);
        this.description = description;
        this.nodes = nodes;
        this.edges = edges;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Hide Nodes and Edges");
        tm.setProgress(0.0);
        CyNetwork network = (CyNetwork)this.view.getModel();
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.nodes != null) {
            elements.addAll(this.nodes);
        }
        tm.setProgress(0.1);
        if (this.edges != null) {
            elements.addAll(this.edges);
        }
        tm.setProgress(0.2);
        UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        undoSupport.postEdit((AbstractCyEdit)new HideEdit(this.description, this.view, elements, false, eventHelper, vmMgr));
        tm.setProgress(0.4);
        if (this.nodes != null) {
            HideUtils.setVisibleNodes(this.nodes, false, this.view);
        }
        tm.setProgress(0.6);
        if (this.edges != null) {
            HideUtils.setVisibleEdges(this.edges, false, this.view);
        }
        tm.setProgress(0.8);
        VisualStyle style = vmMgr.getVisualStyle(this.view);
        for (CyIdentifiable cyIdentifiable : elements) {
            View ev = null;
            if (cyIdentifiable instanceof CyNode) {
                ev = this.view.getNodeView((CyNode)cyIdentifiable);
            } else if (cyIdentifiable instanceof CyEdge) {
                ev = this.view.getEdgeView((CyEdge)cyIdentifiable);
            }
            if (ev == null) continue;
            style.apply(network.getRow(cyIdentifiable), ev);
        }
        this.view.updateView();
        tm.setProgress(1.0);
    }
}

