/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.hide;

import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.task.internal.hide.HideTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class HideFromSelectionTask
extends AbstractNetworkViewTask {
    private final String description;
    private final boolean hideNodes;
    private final boolean hideEdges;
    private final boolean selectionValue;
    private final CyServiceRegistrar serviceRegistrar;

    public HideFromSelectionTask(String description, boolean hideNodes, boolean hideEdges, boolean selectionValue, CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        super(view);
        this.description = description;
        this.hideNodes = hideNodes;
        this.hideEdges = hideEdges;
        this.selectionValue = selectionValue;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Hide Selected Nodes and Edges");
        tm.setProgress(0.0);
        CyNetwork network = (CyNetwork)this.view.getModel();
        List nodes = null;
        List edges = null;
        if (this.hideNodes) {
            nodes = CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)this.selectionValue);
        }
        tm.setProgress(0.1);
        if (this.hideEdges) {
            edges = CyTableUtil.getEdgesInState((CyNetwork)network, (String)"selected", (boolean)this.selectionValue);
        }
        HideTask hideTask = new HideTask(this.description, nodes, edges, this.view, this.serviceRegistrar);
        this.insertTasksAfterCurrentTask(new Task[]{hideTask});
    }
}

