/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.edit.UnGroupNodesTaskFactory;
import org.cytoscape.task.edit.UnGroupTaskFactory;
import org.cytoscape.task.internal.group.UnGroupNodesTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class UnGroupNodesTaskFactoryImpl
implements NetworkViewTaskFactory,
UnGroupTaskFactory,
UnGroupNodesTaskFactory,
TaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public UnGroupNodesTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public boolean isReady(View<CyNode> nodeView, CyNetworkView netView) {
        if (nodeView == null || netView == null) {
            return false;
        }
        ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
        nodeList.add((CyNode)nodeView.getModel());
        CyNetwork net = (CyNetwork)netView.getModel();
        return this.getGroups(net, nodeList).size() > 0;
    }

    public boolean isReady(CyNetworkView netView) {
        List selNodes;
        if (netView == null) {
            return false;
        }
        CyNetwork net = (CyNetwork)netView.getModel();
        return this.getGroups(net, selNodes = CyTableUtil.getNodesInState((CyNetwork)net, (String)"selected", (boolean)true)).size() > 0;
    }

    public boolean isReady() {
        return true;
    }

    public TaskIterator createTaskIterator(View<CyNode> nodeView, CyNetworkView netView) {
        ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
        CyNetwork net = (CyNetwork)netView.getModel();
        nodeList.add((CyNode)nodeView.getModel());
        nodeList.addAll(CyTableUtil.getNodesInState((CyNetwork)net, (String)"selected", (boolean)true));
        Set<CyGroup> groups = this.getGroups(net, nodeList);
        return new TaskIterator(new Task[]{new UnGroupNodesTask(net, groups, netView, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(CyNetworkView netView) {
        CyNetwork net = (CyNetwork)netView.getModel();
        List selNodes = CyTableUtil.getNodesInState((CyNetwork)net, (String)"selected", (boolean)true);
        Set<CyGroup> groups = this.getGroups(net, selNodes);
        return new TaskIterator(new Task[]{new UnGroupNodesTask((CyNetwork)netView.getModel(), groups, netView, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new UnGroupNodesTask(this.serviceRegistrar)});
    }

    private Set<CyGroup> getGroups(CyNetwork net, List<CyNode> nodeList) {
        HashSet<CyGroup> groupList = new HashSet<CyGroup>();
        CyGroupManager mgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        for (CyNode node : nodeList) {
            if (mgr.isGroup(node, net)) {
                groupList.add(mgr.getGroup(node, net));
                continue;
            }
            if (mgr.getGroupsForNode(node, net) == null) continue;
            groupList.addAll(mgr.getGroupsForNode(node, net));
        }
        return groupList;
    }
}

