/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.group.AbstractGroupTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class RenameGroupTask
extends AbstractGroupTask {
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @Tunable(description="Group to rename", context="nogui", longDescription="Specifies the name used to identify the group. ", exampleStringValue="MyLocus")
    public String groupName;
    @Tunable(description="New name", context="nogui", longDescription="Specifies the NEW name used to identify the group. ", exampleStringValue="ImprovedLocus")
    public String newName;

    public RenameGroupTask(CyApplicationManager appMgr, CyGroupManager manager, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.net = appMgr.getCurrentNetwork();
    }

    public void run(TaskMonitor tm) throws Exception {
        if (this.network != null) {
            this.net = this.network;
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        if (this.groupName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Group must be specified");
            throw new RuntimeException("Group must be specified");
        }
        if (this.newName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "New name must be specified");
            throw new RuntimeException("New name must be specified");
        }
        CyGroup grp = this.getGroup(this.groupName);
        if (grp == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find group '" + this.groupName + "' in network: " + this.net.toString());
            throw new RuntimeException("Can't find group '" + this.groupName + "' in network: " + this.net.toString());
        }
        CyRow groupRow = ((CySubNetwork)this.net).getRootNetwork().getRow((CyIdentifiable)grp.getGroupNode(), "SHARED_ATTRS");
        String oldName = (String)groupRow.get("shared name", String.class);
        groupRow.set("shared name", (Object)this.newName);
        tm.showMessage(TaskMonitor.Level.INFO, "Renamed group from " + oldName + " to " + this.newName);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, CyGroup.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(CyGroup.class)) {
            return this.getGroup(this.groupName);
        }
        if (requestedType.equals(String.class)) {
            return this.groupName;
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }
}

