/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTaskFactory;
import org.cytoscape.task.NodeViewTaskFactory;
import org.cytoscape.task.edit.GroupNodesTaskFactory;
import org.cytoscape.task.internal.group.GroupNodesTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class GroupNodesTaskFactoryImpl
extends AbstractNetworkViewTaskFactory
implements NodeViewTaskFactory,
GroupNodesTaskFactory,
TaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public GroupNodesTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(CyNetworkView view) {
        return new TaskIterator(new Task[]{new GroupNodesTask(view, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(View<CyNode> nodeView, CyNetworkView view) {
        return new TaskIterator(new Task[]{new GroupNodesTask(view, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new GroupNodesTask(this.serviceRegistrar)});
    }

    public boolean isReady(CyNetworkView netView) {
        if (netView == null) {
            return false;
        }
        CyNetwork net = (CyNetwork)netView.getModel();
        List selNodes = CyTableUtil.getNodesInState((CyNetwork)net, (String)"selected", (boolean)true);
        return selNodes.size() > 1;
    }

    public boolean isReady(View<CyNode> nodeView, CyNetworkView netView) {
        if (nodeView == null || netView == null) {
            return false;
        }
        CyNetwork net = (CyNetwork)netView.getModel();
        List selNodes = CyTableUtil.getNodesInState((CyNetwork)net, (String)"selected", (boolean)true);
        return selNodes.size() > 1;
    }

    public boolean isReady() {
        return true;
    }
}

