/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.group.GroupEdit;
import org.cytoscape.task.internal.utils.NodeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class GroupNodesTask
extends AbstractTask
implements ObservableTask {
    private CyNetworkView netView;
    private CyGroup newGroup;
    private final CyServiceRegistrar serviceRegistrar;
    private static int groupNumber = 1;
    @ContainsTunables
    public NodeTunable nodeTunable;
    @Tunable(description="Enter group name:", longDescription="Specifies the name used to identify the group. ", exampleStringValue="MyLocus")
    public String groupName;

    public GroupNodesTask(CyNetworkView netView, CyServiceRegistrar serviceRegistrar) {
        this.netView = netView;
        this.serviceRegistrar = serviceRegistrar;
        if (this.groupName == null) {
            this.groupName = "Group " + groupNumber;
            ++groupNumber;
        }
    }

    public GroupNodesTask(CyServiceRegistrar serviceRegistrar) {
        this.netView = null;
        this.serviceRegistrar = serviceRegistrar;
        this.nodeTunable = new NodeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        List selNodes;
        CyNetwork net;
        tm.setProgress(0.0);
        if (this.netView == null && this.nodeTunable == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "No network view!");
            return;
        }
        if (this.netView != null) {
            net = (CyNetwork)this.netView.getModel();
            selNodes = CyTableUtil.getNodesInState((CyNetwork)net, (String)"selected", (boolean)true);
        } else {
            net = this.nodeTunable.getNetwork();
            selNodes = this.nodeTunable.getNodeList();
        }
        CyGroupFactory factory = (CyGroupFactory)this.serviceRegistrar.getService(CyGroupFactory.class);
        this.newGroup = factory.createGroup(net, selNodes, null, true);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new GroupEdit(this.newGroup, this.serviceRegistrar));
        CyRow groupRow = ((CySubNetwork)net).getRootNetwork().getRow((CyIdentifiable)this.newGroup.getGroupNode(), "SHARED_ATTRS");
        groupRow.set("shared name", (Object)this.groupName);
        tm.showMessage(TaskMonitor.Level.INFO, "Created group " + this.groupName + " with " + selNodes.size() + " nodes");
        tm.setProgress(1.0);
    }

    public Object getResults(Class requestedType) {
        if (this.newGroup == null) {
            return null;
        }
        if (requestedType.equals(CyGroup.class)) {
            return this.newGroup;
        }
        if (requestedType.equals(String.class)) {
            return this.newGroup.toString();
        }
        if (requestedType.equals(JSONResult.class)) {
            CyJSONUtil jsonUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
            JSONResult res = () -> {
                if (this.newGroup == null) {
                    return "{}";
                }
                return "{\"group\":" + this.newGroup.getGroupNode().getSUID() + "}";
            };
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, CyGroup.class, JSONResult.class);
    }
}

