/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.filter;

import org.cytoscape.filter.TransformerContainer;
import org.cytoscape.filter.TransformerManager;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.filter.ContainerTunable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class RenameFilterTask
extends AbstractTask {
    @Tunable
    public String name;
    @Tunable
    public String newName;
    @ContainsTunables
    public ContainerTunable containerTunable = new ContainerTunable();
    private final CyServiceRegistrar serviceRegistrar;

    public RenameFilterTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.name == null || this.name.isEmpty()) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "name is missing");
            return;
        }
        if (this.newName == null || this.newName.isEmpty()) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "newName is missing");
            return;
        }
        TransformerContainer<CyNetwork, CyIdentifiable> container = this.containerTunable.getContainer(this.serviceRegistrar);
        if (container == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "container type not found: '" + this.containerTunable.getValue() + "'");
            return;
        }
        NamedTransformer transformer = container.getNamedTransformer(this.name);
        if (transformer == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "filter with name '" + this.name + "' not found");
            return;
        }
        TransformerManager transformerManager = (TransformerManager)this.serviceRegistrar.getService(TransformerManager.class);
        NamedTransformer newTransformer = transformerManager.createNamedTransformer(this.newName, transformer.getTransformers());
        container.removeNamedTransformer(this.name);
        container.addNamedTransformer(newTransformer);
    }
}

