/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.filter;

import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.filter.TransformerContainer;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.io.read.CyTransformerReader;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.filter.ContainerTunable;
import org.cytoscape.task.internal.filter.SelectFilterTask;
import org.cytoscape.task.internal.filter.SelectTunable;
import org.cytoscape.task.internal.filter.TransformerJsonTunable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class CreateFilterTask
extends AbstractTask {
    @Tunable
    public String name;
    @Tunable(description="If true the filter will be applied to the current network immediately after it is created. Default is true.")
    public boolean apply = true;
    @ContainsTunables
    public TransformerJsonTunable jsonTunable = new TransformerJsonTunable();
    @ContainsTunables
    public ContainerTunable containerTunable = new ContainerTunable();
    private final CyServiceRegistrar serviceRegistrar;

    public CreateFilterTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public CreateFilterTask(CyServiceRegistrar serviceRegistrar, String name, boolean apply) {
        this(serviceRegistrar);
        this.name = name;
        this.apply = apply;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        CyNetwork network;
        CyTransformerReader transformerReader;
        NamedTransformer<CyNetwork, CyIdentifiable> transformer;
        if (this.name == null || this.name.isEmpty()) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "name is missing");
            return;
        }
        TransformerContainer<CyNetwork, CyIdentifiable> container = this.containerTunable.getContainer(this.serviceRegistrar);
        if (container == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "container type not found: '" + this.containerTunable.getValue() + "'");
            return;
        }
        NamedTransformer existingTransformer = container.getNamedTransformer(this.name);
        if (existingTransformer != null) {
            container.removeNamedTransformer(this.name);
        }
        if ((transformer = this.jsonTunable.getTransformer(this.name, transformerReader = (CyTransformerReader)this.serviceRegistrar.getService(CyTransformerReader.class))) == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "Error parsing Filter JSON");
            throw new Exception("Error parsing Filter JSON");
        }
        List<String> errors = TransformerJsonTunable.validate(transformer);
        if (!errors.isEmpty()) {
            throw new Exception("Transformer '" + transformer.getName() + "' is not valid: " + String.join((CharSequence)",", errors));
        }
        container.addNamedTransformer(transformer);
        if (this.apply && (network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork()) != null) {
            int[] result = SelectFilterTask.applyFilter(this.serviceRegistrar, network, transformer, SelectTunable.Action.SELECT);
            taskMonitor.showMessage(TaskMonitor.Level.INFO, SelectFilterTask.getResultMessage(result));
        }
    }
}

