/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.net.URISyntaxException;
import java.net.URL;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.io.read.CyNetworkReaderManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.network.LoadNetworkTask;
import org.cytoscape.task.internal.export.network.LoadNetworkURLTask;
import org.cytoscape.task.read.LoadNetworkURLTaskFactory;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;

public class LoadNetworkURLTaskFactoryImpl
extends AbstractTaskFactory
implements LoadNetworkURLTaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public LoadNetworkURLTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(2, new Task[]{new LoadNetworkURLTask(this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(URL url) {
        return this.loadCyNetworks(url);
    }

    public TaskIterator createTaskIterator(URL url, TaskObserver observer) {
        return this.loadCyNetworks(url);
    }

    public TaskIterator loadCyNetworks(URL url) {
        String urlString = url.getFile();
        String[] parts = urlString.split("/");
        String name = parts[parts.length - 1];
        CyNetworkReader reader = null;
        try {
            reader = ((CyNetworkReaderManager)this.serviceRegistrar.getService(CyNetworkReaderManager.class)).getReader(url.toURI(), url.toURI().toString());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return new TaskIterator(2, new Task[]{new LoadNetworkTask(reader, name, this.serviceRegistrar)});
    }
}

