/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.write.CyNetworkViewWriterFactory;
import org.cytoscape.io.write.CyNetworkViewWriterManager;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.task.internal.export.TunableAbstractCyWriter;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;

public final class CyNetworkViewWriter
extends TunableAbstractCyWriter<CyNetworkViewWriterFactory, CyNetworkViewWriterManager> {
    private final CyNetworkView view;

    public CyNetworkViewWriter(CyNetworkViewWriterManager writerManager, CyApplicationManager cyApplicationManager, CyNetworkView view) {
        super(writerManager, cyApplicationManager);
        if (view == null) {
            throw new NullPointerException("View is null.");
        }
        this.view = view;
        for (String fileTypeDesc : this.getFileFilterDescriptions()) {
            if (!fileTypeDesc.contains("SIF")) continue;
            this.options.setSelectedValue((Object)fileTypeDesc);
            break;
        }
        this.outputFile = this.getSuggestedFile();
    }

    void setDefaultFileFormatUsingFileExt(File file) {
        String ext = FilenameUtils.getExtension((String)file.getName());
        ext = ext.toLowerCase().trim();
        String searchDesc = "*." + ext;
        for (String fileTypeDesc : this.getFileFilterDescriptions()) {
            if (!fileTypeDesc.contains(searchDesc)) continue;
            this.options.setSelectedValue((Object)fileTypeDesc);
            break;
        }
    }

    @Override
    protected CyWriter getWriter(CyFileFilter filter) throws Exception {
        return ((CyNetworkViewWriterManager)this.writerManager).getWriter(this.view, filter, (OutputStream)this.outputStream);
    }

    @Override
    @Tunable(description="Save Network as:", params="fileCategory=network;input=false", dependsOn="options!=", gravity=1.1)
    public File getOutputFile() {
        return this.outputFile;
    }

    @ProvidesTitle
    public String getTitle() {
        return "Export Network";
    }

    @Override
    protected String getExportName() {
        String name = (String)this.view.getVisualProperty(BasicVisualLexicon.NETWORK_TITLE);
        if (name == null || name.trim().isEmpty()) {
            name = (String)((CyNetwork)this.view.getModel()).getRow((CyIdentifiable)this.view.getModel()).get("name", String.class);
        }
        return name;
    }
}

