/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.network.GenerateNetworkViewsTask;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public abstract class AbstractLoadNetworkTask
extends AbstractTask {
    private final String VIEW_THRESHOLD = "viewThreshold";
    private static final int DEF_VIEW_THRESHOLD = 3000;
    protected int viewThreshold;
    protected URI uri;
    protected TaskMonitor taskMonitor;
    protected String name;
    protected boolean interrupted;
    protected final CyServiceRegistrar serviceRegistrar;

    @ProvidesTitle
    public String getTitle() {
        return "Import Network";
    }

    public AbstractLoadNetworkTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.viewThreshold = this.getViewThreshold();
    }

    protected void loadNetwork(CyNetworkReader reader) throws Exception {
        if (reader == null) {
            throw new IllegalArgumentException("Could not read file: Network Reader is null.");
        }
        if (this.taskMonitor != null) {
            this.taskMonitor.setStatusMessage("Reading in Network Data...");
            this.taskMonitor.setProgress(0.0);
            this.taskMonitor.setStatusMessage("Creating Cytoscape Network...");
        }
        GenerateNetworkViewsTask generateViewsTask = new GenerateNetworkViewsTask(this.name, reader, this.viewThreshold, this.serviceRegistrar);
        this.insertTasksAfterCurrentTask(new Task[]{reader, generateViewsTask});
        if (this.taskMonitor != null) {
            this.taskMonitor.setProgress(1.0);
        }
    }

    private int getViewThreshold() {
        int threshold;
        Properties props = (Properties)((CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)")).getProperties();
        String vts = props.getProperty("viewThreshold");
        try {
            threshold = Integer.parseInt(vts);
        }
        catch (Exception e) {
            threshold = 3000;
        }
        return threshold;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (this.interrupted) {
            return null;
        }
        if (requestedType.equals(String.class)) {
            return this.name;
        }
        if (requestedType.equals(JSONResult.class)) {
            return this.name;
        }
        return null;
    }
}

