/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.command.util.NodeList;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.AddedEdgesEvent;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.edit.ConnectSelectedNodesEdit;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class ConnectSelectedNodesTask
extends AbstractTask
implements ObservableTask {
    static final String DEFAULT_INTERACTION = "interacts with";
    private final CyServiceRegistrar serviceRegistrar;
    private List<CyEdge> newEdges;
    private CyNetwork network;
    @Tunable(description="The list of nodes to connect", longDescription="Specifies a list of nodes. The keywords ```all```, ```selected```, or ```unselected``` can be used to specify nodes by their selection state. The pattern ```COLUMN:VALUE``` sets this parameter to any rows that contain the specified column value; if the ```COLUMN``` prefix is not used, the NAME column is matched by default. A list of ```COLUMN:VALUE``` pairs of the format ```COLUMN1:VALUE1,COLUMN2:VALUE2,...``` can be used to match multiple values.", exampleStringValue="selected", context="nogui", required=true)
    public NodeList nodes = null;

    @Tunable(description="The network containing the nodes to connect", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui", required=true)
    public CyNetwork getnetwork() {
        return this.network;
    }

    public void setnetwork(CyNetwork net) {
        this.network = net;
        if (this.nodes == null) {
            this.nodes = new NodeList(net);
        } else {
            this.nodes.setNetwork(net);
        }
    }

    public ConnectSelectedNodesTask(CyNetwork network, CyServiceRegistrar serviceRegistrar) {
        this.network = network;
        this.serviceRegistrar = serviceRegistrar;
        this.nodes = new NodeList();
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        tm.setTitle("Connecting Selected Nodes");
        tm.setStatusMessage("Connecting nodes.  Please wait...");
        if (this.network == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
            return;
        }
        List selectedNodes = this.nodes.getValue() == null || this.nodes.getValue().isEmpty() ? CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true) : this.nodes.getValue();
        tm.setProgress(0.1);
        int selectedNodesCount = selectedNodes.size();
        int i = 0;
        this.newEdges = new ArrayList<CyEdge>();
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        CyNetworkViewManager networkViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        VisualMappingManager visualMappingManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        eventHelper.silenceEventSource((Object)this.network);
        for (CyNode source : selectedNodes) {
            for (CyNode target : selectedNodes) {
                List sourceNeighborList;
                if (source == target || (sourceNeighborList = this.network.getNeighborList(source, CyEdge.Type.ANY)).contains(target)) continue;
                CyEdge newEdge = this.network.addEdge(source, target, false);
                this.newEdges.add(newEdge);
                String name = (String)this.network.getRow((CyIdentifiable)source).get("name", String.class) + " (interacts with) " + (String)this.network.getRow((CyIdentifiable)target).get("name", String.class);
                this.network.getRow((CyIdentifiable)newEdge).set("name", (Object)name);
                this.network.getRow((CyIdentifiable)newEdge).set("interaction", (Object)DEFAULT_INTERACTION);
            }
            tm.setProgress(0.1 + (double)(++i) / (double)selectedNodesCount * 0.9);
        }
        eventHelper.unsilenceEventSource((Object)this.network);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new ConnectSelectedNodesEdit(this.network, this.newEdges));
        for (CyEdge edge : this.newEdges) {
            eventHelper.addEventPayload((Object)this.network, (Object)edge, AddedEdgesEvent.class);
        }
        eventHelper.flushPayloadEvents();
        for (CyNetworkView view : networkViewManager.getNetworkViews(this.network)) {
            VisualStyle vs = visualMappingManager.getVisualStyle(view);
            vs.apply(view);
            view.updateView();
        }
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        if (type.equals(List.class)) {
            return this.newEdges;
        }
        if (type.equals(String.class)) {
            if (this.newEdges.isEmpty()) {
                return "<none>";
            }
            Object ret = "";
            if (this.newEdges != null && this.newEdges.size() > 0) {
                ret = (String)ret + "Edges added: \n";
                for (CyEdge edge : this.newEdges) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)edge).get("name", String.class) + "\n";
                }
            }
            return ret;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.newEdges == null || this.newEdges.size() == 0) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return "{\"edges\":" + cyJSONUtil.cyIdentifiablesToJson(this.newEdges) + "}";
            };
            return res;
        }
        return this.newEdges;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }
}

