/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.DynamicTaskFactoryProvisioner;
import org.cytoscape.task.NetworkCollectionTaskFactory;
import org.cytoscape.task.NetworkTaskFactory;
import org.cytoscape.task.NetworkViewCollectionTaskFactory;
import org.cytoscape.task.NetworkViewTaskFactory;
import org.cytoscape.task.RowTaskFactory;
import org.cytoscape.task.TableCellTaskFactory;
import org.cytoscape.task.TableColumnTaskFactory;
import org.cytoscape.task.TableTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.Togglable;

public class DynamicTaskFactoryProvisionerImpl
implements DynamicTaskFactoryProvisioner {
    private final CyServiceRegistrar serviceRegistrar;

    public DynamicTaskFactoryProvisionerImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskFactory createFor(NetworkTaskFactory factory) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory) : new DynamicTaskFactory(factory);
    }

    public TaskFactory createFor(NetworkViewTaskFactory factory) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory) : new DynamicTaskFactory(factory);
    }

    public TaskFactory createFor(NetworkCollectionTaskFactory factory) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory) : new DynamicTaskFactory(factory);
    }

    public TaskFactory createFor(NetworkViewCollectionTaskFactory factory) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory) : new DynamicTaskFactory(factory);
    }

    public TaskFactory createFor(TableTaskFactory factory) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory) : new DynamicTaskFactory(factory);
    }

    public TaskFactory createFor(TableColumnTaskFactory factory, CyColumn column) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory, column) : new DynamicTaskFactory(factory, column);
    }

    public TaskFactory createFor(RowTaskFactory factory, CyRow row) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory, row) : new DynamicTaskFactory(factory, row);
    }

    public TaskFactory createFor(TableCellTaskFactory factory, CyColumn column, Object primaryKeyValue) {
        return factory instanceof Togglable ? new DynamicTogglableTaskFactory(factory, column, primaryKeyValue) : new DynamicTaskFactory(factory, column, primaryKeyValue);
    }

    private CyApplicationManager getApplicationManager() {
        return (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
    }

    private class DynamicTogglableTaskFactory
    extends DynamicTaskFactory
    implements Togglable {
        DynamicTogglableTaskFactory(Object factory) {
            super(factory);
        }

        DynamicTogglableTaskFactory(TableColumnTaskFactory factory, CyColumn column) {
            super(factory, column);
        }

        DynamicTogglableTaskFactory(RowTaskFactory factory, CyRow row) {
            super(factory, row);
        }

        DynamicTogglableTaskFactory(TableCellTaskFactory factory, CyColumn column, Object pkValue) {
            super(factory, column, pkValue);
        }

        public boolean isOn() {
            if (this.factory instanceof NetworkTaskFactory) {
                return ((NetworkTaskFactory)this.factory).isOn(DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getCurrentNetwork());
            }
            if (this.factory instanceof NetworkViewTaskFactory) {
                return ((NetworkViewTaskFactory)this.factory).isOn(DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getCurrentNetworkView());
            }
            if (this.factory instanceof NetworkCollectionTaskFactory) {
                return ((NetworkCollectionTaskFactory)this.factory).isOn((Collection)DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getSelectedNetworks());
            }
            if (this.factory instanceof NetworkViewCollectionTaskFactory) {
                return ((NetworkViewCollectionTaskFactory)this.factory).isOn((Collection)DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getSelectedNetworkViews());
            }
            if (this.factory instanceof TableTaskFactory) {
                return ((TableTaskFactory)this.factory).isOn(DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getCurrentTable());
            }
            if (this.factory instanceof TableColumnTaskFactory) {
                return ((TableColumnTaskFactory)this.factory).isOn((CyColumn)this.targetReference.get());
            }
            if (this.factory instanceof RowTaskFactory) {
                return ((RowTaskFactory)this.factory).isOn((CyRow)this.targetReference.get());
            }
            if (this.factory instanceof TableCellTaskFactory) {
                return ((TableCellTaskFactory)this.factory).isOn((CyColumn)this.targetReference.get(), this.pkReference.get());
            }
            return false;
        }
    }

    private class DynamicTaskFactory
    implements TaskFactory {
        protected final Object factory;
        protected Reference<? extends CyIdentifiable> targetReference;
        protected Reference<Object> pkReference;

        DynamicTaskFactory(Object factory) {
            this.factory = factory;
        }

        DynamicTaskFactory(TableColumnTaskFactory factory, CyColumn column) {
            this.factory = factory;
            this.targetReference = new WeakReference<CyColumn>(column);
        }

        DynamicTaskFactory(RowTaskFactory factory, CyRow row) {
            this.factory = factory;
            this.targetReference = new WeakReference<CyRow>(row);
        }

        DynamicTaskFactory(TableCellTaskFactory factory, CyColumn column, Object pkValue) {
            this.factory = factory;
            this.targetReference = new WeakReference<CyColumn>(column);
            this.pkReference = new WeakReference<Object>(pkValue);
        }

        public TaskIterator createTaskIterator() {
            if (this.factory instanceof NetworkTaskFactory) {
                return ((NetworkTaskFactory)this.factory).createTaskIterator(DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getCurrentNetwork());
            }
            if (this.factory instanceof NetworkViewTaskFactory) {
                return ((NetworkViewTaskFactory)this.factory).createTaskIterator(DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getCurrentNetworkView());
            }
            if (this.factory instanceof NetworkCollectionTaskFactory) {
                return ((NetworkCollectionTaskFactory)this.factory).createTaskIterator((Collection)DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getSelectedNetworks());
            }
            if (this.factory instanceof NetworkViewCollectionTaskFactory) {
                return ((NetworkViewCollectionTaskFactory)this.factory).createTaskIterator((Collection)DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getSelectedNetworkViews());
            }
            if (this.factory instanceof TableTaskFactory) {
                return ((TableTaskFactory)this.factory).createTaskIterator(DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getCurrentTable());
            }
            if (this.factory instanceof TableColumnTaskFactory) {
                return ((TableColumnTaskFactory)this.factory).createTaskIterator((CyColumn)this.targetReference.get());
            }
            if (this.factory instanceof RowTaskFactory) {
                return ((RowTaskFactory)this.factory).createTaskIterator((CyRow)this.targetReference.get());
            }
            if (this.factory instanceof TableCellTaskFactory) {
                return ((TableCellTaskFactory)this.factory).createTaskIterator((CyColumn)this.targetReference.get(), this.pkReference.get());
            }
            return new TaskIterator(new Task[0]);
        }

        public boolean isReady() {
            if (this.factory instanceof NetworkTaskFactory) {
                return ((NetworkTaskFactory)this.factory).isReady(DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getCurrentNetwork());
            }
            if (this.factory instanceof NetworkViewTaskFactory) {
                return ((NetworkViewTaskFactory)this.factory).isReady(DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getCurrentNetworkView());
            }
            if (this.factory instanceof NetworkCollectionTaskFactory) {
                return ((NetworkCollectionTaskFactory)this.factory).isReady((Collection)DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getSelectedNetworks());
            }
            if (this.factory instanceof NetworkViewCollectionTaskFactory) {
                return ((NetworkViewCollectionTaskFactory)this.factory).isReady((Collection)DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getSelectedNetworkViews());
            }
            if (this.factory instanceof TableTaskFactory) {
                return ((TableTaskFactory)this.factory).isReady(DynamicTaskFactoryProvisionerImpl.this.getApplicationManager().getCurrentTable());
            }
            if (this.factory instanceof TableColumnTaskFactory) {
                return ((TableColumnTaskFactory)this.factory).isReady((CyColumn)this.targetReference.get());
            }
            if (this.factory instanceof RowTaskFactory) {
                return ((RowTaskFactory)this.factory).isReady((CyRow)this.targetReference.get());
            }
            if (this.factory instanceof TableCellTaskFactory) {
                return ((TableCellTaskFactory)this.factory).isReady((CyColumn)this.targetReference.get(), this.pkReference.get());
            }
            return false;
        }
    }
}

