/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.copycatLayout.internal.task;

import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class CopyNetworkViewLocationTask
extends AbstractTask {
    private final CyNetworkView sourceNetworkView;
    private final CyNetworkView targetNetworkView;

    public CopyNetworkViewLocationTask(CyNetworkView source, CyNetworkView target) {
        this.sourceNetworkView = source;
        this.targetNetworkView = target;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Copying network location");
        Double height = (Double)this.sourceNetworkView.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT);
        Double width = (Double)this.sourceNetworkView.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH);
        Double scale = (Double)this.sourceNetworkView.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        this.targetNetworkView.setVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT, (Object)height);
        this.targetNetworkView.setVisualProperty(BasicVisualLexicon.NETWORK_WIDTH, (Object)width);
        this.targetNetworkView.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)scale);
        Double x_center = (Double)this.sourceNetworkView.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION);
        Double y_center = (Double)this.sourceNetworkView.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION);
        Double z_center = (Double)this.sourceNetworkView.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION);
        this.targetNetworkView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, (Object)x_center);
        this.targetNetworkView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, (Object)y_center);
        this.targetNetworkView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION, (Object)z_center);
    }
}

