/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.util;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.slf4j.Logger;

public final class Util {
    public static List<View<CyNode>> findSelectedNodes(CyNetworkView view) {
        ArrayList<View<CyNode>> snv = new ArrayList<View<CyNode>>();
        for (CyNode n : CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)view.getModel()), (String)"selected", (boolean)true)) {
            snv.add((View<CyNode>)view.getNodeView(n));
        }
        return snv;
    }

    public static void invokeOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeOnEDTAndWait(Runnable runnable) {
        Util.invokeOnEDTAndWait(runnable, null);
    }

    public static void invokeOnEDTAndWait(Runnable runnable, Logger logger) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error("Unexpected error", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    public static JButton createButton(Action a, String tt) {
        JButton b = new JButton(a);
        b.setToolTipText(tt);
        b.setPreferredSize(new Dimension(32, 24));
        b.setMaximumSize(new Dimension(32, 24));
        b.setMinimumSize(new Dimension(32, 24));
        b.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        b.setBorderPainted(false);
        b.setOpaque(false);
        b.setContentAreaFilled(false);
        return b;
    }

    private Util() {
    }
}

