/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.scale;

import org.cytoscape.math.xform.AffineTransform3D;
import org.cytoscape.math.xform.Scale3D;
import org.cytoscape.math.xform.Translation3D;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.manual.internal.layout.algorithm.MutablePolyEdgeGraphLayout;

public final class ScaleLayouter {
    private final MutablePolyEdgeGraphLayout m_graph;
    private final Translation3D m_translationToOrig;
    private final Translation3D m_translationFromOrig;
    private final double[] m_pointBuff = new double[3];

    public ScaleLayouter(MutablePolyEdgeGraphLayout graph) {
        this.m_graph = graph;
        double xMin = Double.MAX_VALUE;
        double xMax = Double.MIN_VALUE;
        double yMin = Double.MAX_VALUE;
        double yMax = Double.MIN_VALUE;
        for (CyEdge edge : this.m_graph.edges()) {
            if (!this.m_graph.isMovableNode(edge.getSource()) && !this.m_graph.isMovableNode(edge.getTarget())) continue;
        }
        for (CyNode node : this.m_graph.nodes()) {
            if (!this.m_graph.isMovableNode(node)) continue;
            double nodeXPosition = this.m_graph.getNodePosition(node, true);
            double nodeYPosition = this.m_graph.getNodePosition(node, false);
            xMin = Math.min(xMin, nodeXPosition);
            xMax = Math.max(xMax, nodeXPosition);
            yMin = Math.min(yMin, nodeYPosition);
            yMax = Math.max(yMax, nodeYPosition);
        }
        if (xMax < 0.0) {
            this.m_translationToOrig = null;
            this.m_translationFromOrig = null;
        } else {
            double xRectCenter = (xMin + xMax) / 2.0;
            double yRectCenter = (yMin + yMax) / 2.0;
            this.m_translationToOrig = new Translation3D(-xRectCenter, -yRectCenter, 0.0);
            this.m_translationFromOrig = new Translation3D(xRectCenter, yRectCenter, 0.0);
        }
    }

    public void scaleGraph(double scaleFactor, Direction direction) {
        if (scaleFactor < 0.001 || scaleFactor > 1000.0) {
            throw new IllegalArgumentException("scaleFactor is outside allowable range [0.001, 1000.0]");
        }
        if (this.m_translationToOrig == null) {
            return;
        }
        double xFactor = scaleFactor;
        double yFactor = scaleFactor;
        switch (direction) {
            case X_AXIS_ONLY: {
                yFactor = 1.0;
                break;
            }
            case Y_AXIS_ONLY: {
                xFactor = 1.0;
                break;
            }
        }
        AffineTransform3D xform = this.m_translationToOrig.concatenatePost(new Scale3D(xFactor, yFactor, 1.0).concatenatePost(this.m_translationFromOrig));
        for (CyNode node : this.m_graph.nodes()) {
            if (!this.m_graph.isMovableNode(node)) continue;
            this.m_pointBuff[0] = this.m_graph.getNodePosition(node, true);
            this.m_pointBuff[1] = this.m_graph.getNodePosition(node, false);
            this.m_pointBuff[2] = 0.0;
            xform.transformArr(this.m_pointBuff);
            this.m_graph.setNodePosition(node, this.m_pointBuff[0], this.m_pointBuff[1]);
        }
        for (CyEdge edge : this.m_graph.edges()) {
            if (!this.m_graph.isMovableNode(edge.getSource()) && !this.m_graph.isMovableNode(edge.getTarget())) continue;
        }
    }

    public static enum Direction {
        X_AXIS_ONLY,
        Y_AXIS_ONLY,
        BOTH_AXES;

    }
}

