/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.rotate;

import org.cytoscape.math.xform.AffineTransform3D;
import org.cytoscape.math.xform.AxisRotation3D;
import org.cytoscape.math.xform.Translation3D;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.manual.internal.layout.algorithm.MutablePolyEdgeGraphLayout;

public final class RotationLayouter {
    private final MutablePolyEdgeGraphLayout m_graph;
    private Translation3D m_translationToOrig;
    private Translation3D m_translationFromOrig;
    private final double[] m_pointBuff = new double[3];

    public RotationLayouter(MutablePolyEdgeGraphLayout graph) {
        this.m_graph = graph;
        double xMin = Double.MAX_VALUE;
        double xMax = Double.MIN_VALUE;
        double yMin = Double.MAX_VALUE;
        double yMax = Double.MIN_VALUE;
        for (CyEdge edge : this.m_graph.edges()) {
            if (this.m_graph.isMovableNode(edge.getSource()) && this.m_graph.isMovableNode(edge.getTarget())) continue;
        }
        for (CyNode node : this.m_graph.nodes()) {
            if (!this.m_graph.isMovableNode(node)) continue;
            double nodeXPosition = this.m_graph.getNodePosition(node, true);
            double nodeYPosition = this.m_graph.getNodePosition(node, false);
            xMin = Math.min(xMin, nodeXPosition);
            xMax = Math.max(xMax, nodeXPosition);
            yMin = Math.min(yMin, nodeYPosition);
            yMax = Math.max(yMax, nodeYPosition);
        }
        if (xMax < 0.0) {
            return;
        }
        double xRectCenter = (xMin + xMax) / 2.0;
        double yRectCenter = (yMin + yMax) / 2.0;
        double rectWidth = xMax - xMin;
        double rectHeight = yMax - yMin;
        double hypotenuse = 0.5 * Math.sqrt(rectWidth * rectWidth + rectHeight * rectHeight);
        if (xRectCenter - hypotenuse < 0.0 || xRectCenter + hypotenuse > this.m_graph.getMaxWidth() || yRectCenter - hypotenuse < 0.0 || yRectCenter + hypotenuse > this.m_graph.getMaxHeight()) {
            return;
        }
        this.m_translationToOrig = new Translation3D(-xRectCenter, -yRectCenter, 0.0);
        this.m_translationFromOrig = new Translation3D(xRectCenter, yRectCenter, 0.0);
    }

    public void rotateGraph(double radians) {
        if (this.m_translationToOrig == null) {
            return;
        }
        AffineTransform3D xform = this.m_translationToOrig.concatenatePost(new AxisRotation3D(4, radians).concatenatePost(this.m_translationFromOrig));
        for (CyNode node : this.m_graph.nodes()) {
            if (!this.m_graph.isMovableNode(node)) continue;
            this.m_pointBuff[0] = this.m_graph.getNodePosition(node, true);
            this.m_pointBuff[1] = this.m_graph.getNodePosition(node, false);
            this.m_pointBuff[2] = 0.0;
            xform.transformArr(this.m_pointBuff);
            this.m_graph.setNodePosition(node, this.m_pointBuff[0], this.m_pointBuff[1]);
        }
        for (CyEdge edge : this.m_graph.edges()) {
            if (this.m_graph.isMovableNode(edge.getSource()) && this.m_graph.isMovableNode(edge.getTarget())) continue;
        }
    }
}

