/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.control.view;

import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.manual.internal.control.view.AlignPanel;
import org.cytoscape.view.manual.internal.control.view.DistPanel;
import org.cytoscape.view.manual.internal.control.view.StackPanel;
import org.cytoscape.view.manual.internal.rotate.RotatePanel;
import org.cytoscape.view.manual.internal.scale.ScalePanel;
import org.cytoscape.view.manual.internal.util.Util;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;

public class LayoutToolsPanel
extends JPanel
implements CytoPanelComponent2,
SessionAboutToBeLoadedListener,
SessionLoadedListener,
SetCurrentNetworkViewListener,
RowsSetListener {
    private static final String TITLE = "Layout Tools";
    private static final String ID = "org.cytoscape.NodeLayoutTools";
    private ScalePanel scalePanel;
    private AlignPanel alignPanel;
    private DistPanel distPanel;
    private StackPanel stackPanel;
    private RotatePanel rotatePanel;
    private TextIcon icon;
    private boolean loadingSession;
    private final CyServiceRegistrar serviceRegistrar;

    public LayoutToolsPanel(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        CyApplicationManager appMgr = (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class);
        IconManager iconMgr = (IconManager)serviceRegistrar.getService(IconManager.class);
        this.scalePanel = new ScalePanel(appMgr, iconMgr);
        this.alignPanel = new AlignPanel(appMgr);
        this.distPanel = new DistPanel(appMgr);
        this.stackPanel = new StackPanel(appMgr);
        this.rotatePanel = new RotatePanel(appMgr);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(false);
        int gap = 10;
        int w = 320;
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(gap, gap, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.scalePanel, -1, w, w).addComponent(this.alignPanel, -1, w, w).addComponent(this.distPanel, -1, w, w).addComponent(this.stackPanel, -1, w, w).addComponent(this.rotatePanel, -1, w, w)).addGap(gap, gap, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.scalePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.alignPanel, -2, -1, -2).addComponent(this.distPanel, -2, -1, -2).addComponent(this.stackPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rotatePanel, -2, -1, -2));
        if (LookAndFeelUtil.isAquaLAF()) {
            this.setOpaque(false);
        }
        this.updatePanels();
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.SOUTH_WEST;
    }

    public String getTitle() {
        return TITLE;
    }

    public Component getComponent() {
        return this;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new TextIcon("*", ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 14.0f), 16, 16);
        }
        return this.icon;
    }

    public String getIdentifier() {
        return ID;
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.loadingSession = false;
        this.updatePanels();
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (!this.loadingSession) {
            this.updatePanels();
        }
    }

    public void handleEvent(RowsSetEvent e) {
        if (this.loadingSession) {
            return;
        }
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkView currentView = appMgr.getCurrentNetworkView();
        if (currentView == null) {
            return;
        }
        CyTable tbl = (CyTable)e.getSource();
        CyNetworkTableManager netTblMgr = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
        CyNetwork net = netTblMgr.getNetworkForTable(tbl);
        if (net == null || !net.equals(currentView.getModel()) || !tbl.equals(net.getDefaultNodeTable())) {
            return;
        }
        Collection selectedRecords = e.getColumnRecords("selected");
        if (!selectedRecords.isEmpty()) {
            this.updatePanels();
        }
    }

    private void updatePanels() {
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkView view = appMgr.getCurrentNetworkView();
        List<View<CyNode>> selectedNodeViews = view != null ? Util.findSelectedNodes(view) : null;
        Util.invokeOnEDT(() -> {
            this.scalePanel.setEnabled(view != null);
            this.rotatePanel.setEnabled(view != null);
            boolean enabled = selectedNodeViews != null && !selectedNodeViews.isEmpty();
            this.alignPanel.setEnabled(enabled);
            this.distPanel.setEnabled(enabled);
            this.stackPanel.setEnabled(enabled);
        });
    }
}

