/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.manual.internal.common;

import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.view.manual.internal.layout.algorithm.MutablePolyEdgeGraphLayout;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;

public final class GraphConverter2 {
    private GraphConverter2() {
    }

    public static MutablePolyEdgeGraphLayout getGraphReference(double percentBorder, boolean preserveEdgeAnchors, boolean onlySelectedNodesMovable, final CyNetworkView graphView) {
        if (percentBorder < 0.0) {
            throw new IllegalArgumentException("percentBorder < 0.0");
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (View currentNodeView : graphView.getNodeViews()) {
            minX = Math.min(minX, (Double)currentNodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION));
            maxX = Math.max(maxX, (Double)currentNodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION));
            minY = Math.min(minY, (Double)currentNodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION));
            maxY = Math.max(maxY, (Double)currentNodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION));
        }
        List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)graphView.getModel()), (String)"selected", (boolean)true);
        final boolean noNodesSelected = !onlySelectedNodesMovable || selectedNodes.size() == 0;
        double border = Math.max(maxX - minX, maxY - minY) * percentBorder * 0.5;
        final double width = maxX - minX + border + border;
        final double height = maxY - minY + border + border;
        final double xOff = minX - border;
        final double yOff = minY - border;
        final CyNetwork fixedGraph = (CyNetwork)graphView.getModel();
        return new MutablePolyEdgeGraphLayout(){

            @Override
            public List<CyNode> nodes() {
                return fixedGraph.getNodeList();
            }

            @Override
            public List<CyEdge> edges() {
                return fixedGraph.getEdgeList();
            }

            @Override
            public double getMaxWidth() {
                return width;
            }

            @Override
            public double getMaxHeight() {
                return height;
            }

            @Override
            public double getNodePosition(CyNode node, boolean xPosition) {
                View nodeView = graphView.getNodeView(node);
                if (xPosition) {
                    return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION) - xOff;
                }
                return (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION) - yOff;
            }

            @Override
            public boolean isMovableNode(CyNode node) {
                if (noNodesSelected) {
                    return true;
                }
                return (Boolean)fixedGraph.getRow((CyIdentifiable)node).get("selected", Boolean.class);
            }

            @Override
            public void setNodePosition(CyNode node, double xPos, double yPos) {
                View nodeView = graphView.getNodeView(node);
                this.checkPosition(xPos, yPos);
                if (!this.isMovableNode(node)) {
                    throw new UnsupportedOperationException("node " + node + " is not movable");
                }
                nodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)(xPos + xOff));
                nodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)(yPos + yOff));
            }

            private void checkPosition(double xPos, double yPos) {
                if (Double.isNaN(xPos) || xPos < 0.0 || xPos > this.getMaxWidth()) {
                    throw new IllegalArgumentException("X position out of bounds");
                }
                if (Double.isNaN(yPos) || yPos < 0.0 || yPos > this.getMaxHeight()) {
                    throw new IllegalArgumentException("Y position out of bounds");
                }
            }
        };
    }
}

