/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.linkout.internal;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.linkout.internal.EdgeLinkoutTaskFactory;
import org.cytoscape.linkout.internal.NodeLinkoutTaskFactory;
import org.cytoscape.property.CyProperty;
import org.cytoscape.property.PropertyUpdatedEvent;
import org.cytoscape.property.PropertyUpdatedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.EdgeViewTaskFactory;
import org.cytoscape.task.NodeViewTaskFactory;
import org.cytoscape.util.swing.OpenBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkOut
implements PropertyUpdatedListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    public static final String NODEMARKER = "nodelinkouturl.";
    public static final String EDGEMARKER = "edgelinkouturl.";
    private final CyProperty<Properties> linkoutProps;
    private final CyServiceRegistrar registrar;
    private final Map<String, NodeLinkoutTaskFactory> propKey2NodeVTF;
    private final Map<String, EdgeLinkoutTaskFactory> propKey2EdgeVTF;
    private final Map<String, NodeLinkoutTaskFactory> cpropKey2NodeVTF;
    private final Map<String, EdgeLinkoutTaskFactory> cpropKey2EdgeVTF;

    public LinkOut(CyProperty<Properties> linkoutProps, CyServiceRegistrar registrar) {
        this.linkoutProps = linkoutProps;
        this.registrar = registrar;
        this.propKey2EdgeVTF = new HashMap<String, EdgeLinkoutTaskFactory>();
        this.propKey2NodeVTF = new HashMap<String, NodeLinkoutTaskFactory>();
        this.cpropKey2EdgeVTF = new HashMap<String, EdgeLinkoutTaskFactory>();
        this.cpropKey2NodeVTF = new HashMap<String, NodeLinkoutTaskFactory>();
        this.readLocalProperties();
        this.addStaticNodeLinks();
        this.addStaticEdgeLinks();
    }

    private void readLocalProperties() {
        CyApplicationConfiguration config = (CyApplicationConfiguration)this.registrar.getService(CyApplicationConfiguration.class);
        File propertyFile = new File(config.getConfigurationDirectoryLocation(), File.separator + "linkout.props");
        try {
            if (propertyFile.canRead()) {
                ((Properties)this.linkoutProps.getProperties()).load(new FileInputStream(propertyFile));
            }
        }
        catch (Exception e) {
            logger.warn("Couldn't load linkout props from '" + propertyFile.getAbsolutePath() + "'.", (Throwable)e);
        }
    }

    private void addStaticNodeLinks() {
        Properties props = (Properties)this.linkoutProps.getProperties();
        OpenBrowser browser = (OpenBrowser)this.registrar.getService(OpenBrowser.class);
        try {
            for (Object pk : props.keySet()) {
                String propKey = pk.toString();
                String url = props.getProperty(propKey);
                Properties dict = this.createProperties(propKey, NODEMARKER);
                if (url == null || dict == null) {
                    logger.debug("Bad URL for propKey: " + propKey);
                    continue;
                }
                NodeLinkoutTaskFactory evtf = new NodeLinkoutTaskFactory(browser, url);
                this.registrar.registerService((Object)evtf, NodeViewTaskFactory.class, dict);
                this.propKey2NodeVTF.put(propKey, evtf);
            }
        }
        catch (Exception e) {
            logger.warn("Problem processing node URLs", (Throwable)e);
        }
    }

    private void addStaticEdgeLinks() {
        Properties props = (Properties)this.linkoutProps.getProperties();
        OpenBrowser browser = (OpenBrowser)this.registrar.getService(OpenBrowser.class);
        try {
            for (Object pk : props.keySet()) {
                String propKey = pk.toString();
                String url = props.getProperty(propKey);
                Properties dict = this.createProperties(propKey, EDGEMARKER);
                if (url == null || dict == null) {
                    logger.debug("Bad URL for propKey: " + propKey);
                    continue;
                }
                EdgeLinkoutTaskFactory evtf = new EdgeLinkoutTaskFactory(browser, url);
                this.registrar.registerService((Object)evtf, EdgeViewTaskFactory.class, dict);
                this.propKey2EdgeVTF.put(propKey, evtf);
            }
        }
        catch (Exception e) {
            logger.warn("Problem processing edge URLs", (Throwable)e);
        }
    }

    private Properties createProperties(String propKey, String marker) {
        int p = propKey.lastIndexOf(marker);
        if (p == -1) {
            return null;
        }
        Properties dict = new Properties();
        String menuKey = marker.equals(NODEMARKER) ? "External Links[1001]." + propKey.substring(p) : "External Links[1001]." + propKey.substring(p += marker.length());
        dict.setProperty("preferredMenu", menuKey);
        dict.setProperty("menuGravity", "-1");
        return dict;
    }

    public void addCommanLineLinkOut(CyProperty<Properties> commandline, Map<?, ?> p) {
        Object evtf;
        Properties dict;
        String url;
        String propKey;
        if (!"commandline.props".equals(p.get("cyPropertyName"))) {
            return;
        }
        Properties props = (Properties)commandline.getProperties();
        OpenBrowser browser = (OpenBrowser)this.registrar.getService(OpenBrowser.class);
        try {
            for (Object pk : props.keySet()) {
                propKey = pk.toString();
                url = props.getProperty(propKey);
                dict = this.createProperties(propKey, EDGEMARKER);
                if (url == null || dict == null) {
                    logger.debug("Bad URL for propKey: " + propKey);
                    continue;
                }
                evtf = new EdgeLinkoutTaskFactory(browser, url);
                this.registrar.registerService(evtf, EdgeViewTaskFactory.class, dict);
                this.cpropKey2EdgeVTF.put(propKey, (EdgeLinkoutTaskFactory)((Object)evtf));
            }
        }
        catch (Exception e) {
            logger.warn("Problem processing edge URLs", (Throwable)e);
        }
        try {
            for (Object pk : props.keySet()) {
                propKey = pk.toString();
                url = props.getProperty(propKey);
                dict = this.createProperties(propKey, NODEMARKER);
                if (url == null || dict == null) {
                    logger.debug("Bad URL for propKey: " + propKey);
                    continue;
                }
                evtf = new NodeLinkoutTaskFactory(browser, url);
                this.registrar.registerService(evtf, NodeViewTaskFactory.class, dict);
                this.cpropKey2NodeVTF.put(propKey, (NodeLinkoutTaskFactory)((Object)evtf));
            }
        }
        catch (Exception e) {
            logger.warn("Problem processing node URLs", (Throwable)e);
        }
    }

    public void removeCommanLineLinkOut(CyProperty<Properties> commandline, Map<?, ?> p) {
        EdgeViewTaskFactory evtf;
        Properties dict;
        String propKey;
        if (!"commandline.props".equals(p.get("cyPropertyName"))) {
            return;
        }
        Properties props = (Properties)commandline.getProperties();
        try {
            for (Object pk : props.keySet()) {
                propKey = pk.toString();
                dict = this.createProperties(propKey, EDGEMARKER);
                if (!this.cpropKey2EdgeVTF.containsKey(propKey)) continue;
                evtf = (EdgeViewTaskFactory)this.cpropKey2EdgeVTF.get(propKey);
                this.registrar.unregisterService((Object)evtf, EdgeViewTaskFactory.class);
                this.cpropKey2EdgeVTF.remove(propKey);
            }
        }
        catch (Exception e) {
            logger.warn("Problem processing edge URLs", (Throwable)e);
        }
        try {
            for (Object pk : props.keySet()) {
                propKey = pk.toString();
                dict = this.createProperties(propKey, NODEMARKER);
                if (!this.cpropKey2NodeVTF.containsKey(propKey)) continue;
                evtf = (NodeViewTaskFactory)this.cpropKey2NodeVTF.get(propKey);
                this.registrar.unregisterService((Object)evtf, NodeViewTaskFactory.class);
                this.cpropKey2NodeVTF.remove(propKey);
            }
        }
        catch (Exception e) {
            logger.warn("Problem processing node URLs", (Throwable)e);
        }
    }

    public void handleEvent(final PropertyUpdatedEvent e) {
        if (e.getSource() == null || ((CyProperty)e.getSource()).getName() == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OpenBrowser browser = (OpenBrowser)LinkOut.this.registrar.getService(OpenBrowser.class);
                if (((CyProperty)e.getSource()).getName().equals("linkout")) {
                    String url;
                    Properties props = (Properties)((CyProperty)e.getSource()).getProperties();
                    ArrayList<String> removedLinks = new ArrayList<String>();
                    for (String propKey : LinkOut.this.propKey2EdgeVTF.keySet()) {
                        if (props.keySet().contains(propKey)) {
                            EdgeLinkoutTaskFactory eltf;
                            url = props.getProperty(propKey);
                            if (url.equals((eltf = LinkOut.this.propKey2EdgeVTF.get(propKey)).getLink())) continue;
                            eltf.setLink(url);
                            LinkOut.this.propKey2EdgeVTF.put(propKey, eltf);
                            continue;
                        }
                        EdgeLinkoutTaskFactory eltf = LinkOut.this.propKey2EdgeVTF.get(propKey);
                        LinkOut.this.registrar.unregisterService((Object)eltf, EdgeViewTaskFactory.class);
                        removedLinks.add(propKey);
                    }
                    for (String propKey : LinkOut.this.propKey2NodeVTF.keySet()) {
                        if (props.keySet().contains(propKey)) {
                            NodeLinkoutTaskFactory nltf;
                            url = props.getProperty(propKey);
                            if (url.equals((nltf = LinkOut.this.propKey2NodeVTF.get(propKey)).getLink())) continue;
                            nltf.setLink(url);
                            LinkOut.this.propKey2NodeVTF.put(propKey, nltf);
                            continue;
                        }
                        NodeLinkoutTaskFactory nltf = LinkOut.this.propKey2NodeVTF.get(propKey);
                        LinkOut.this.registrar.unregisterService((Object)nltf, NodeViewTaskFactory.class);
                        removedLinks.add(propKey);
                    }
                    for (String propkey : removedLinks) {
                        LinkOut.this.propKey2EdgeVTF.remove(propkey);
                        LinkOut.this.propKey2NodeVTF.remove(propkey);
                    }
                    try {
                        Properties dict;
                        String url2;
                        String propKey;
                        for (Object pk : props.keySet()) {
                            propKey = pk.toString();
                            if (LinkOut.this.propKey2EdgeVTF.containsKey(propKey)) continue;
                            url2 = props.getProperty(propKey);
                            dict = LinkOut.this.createProperties(propKey, LinkOut.EDGEMARKER);
                            if (url2 == null || dict == null) {
                                logger.debug("Bad URL for propKey: " + propKey);
                                continue;
                            }
                            EdgeLinkoutTaskFactory evtf = new EdgeLinkoutTaskFactory(browser, url2);
                            LinkOut.this.registrar.registerService((Object)evtf, EdgeViewTaskFactory.class, dict);
                            LinkOut.this.propKey2EdgeVTF.put(propKey, evtf);
                        }
                        for (Object pk : props.keySet()) {
                            propKey = pk.toString();
                            if (LinkOut.this.propKey2NodeVTF.containsKey(propKey)) continue;
                            url2 = props.getProperty(propKey);
                            dict = LinkOut.this.createProperties(propKey, LinkOut.NODEMARKER);
                            if (url2 == null || dict == null) {
                                logger.debug("Bad URL for propKey: " + propKey);
                                continue;
                            }
                            NodeLinkoutTaskFactory nvtf = new NodeLinkoutTaskFactory(browser, url2);
                            LinkOut.this.registrar.registerService((Object)nvtf, NodeViewTaskFactory.class, dict);
                            LinkOut.this.propKey2NodeVTF.put(propKey, nvtf);
                        }
                    }
                    catch (Exception ex) {
                        logger.warn("Problem processing node URLs", (Throwable)ex);
                    }
                } else if (((CyProperty)e.getSource()).getName().equals("commandline")) {
                    String url;
                    Properties props = (Properties)((CyProperty)e.getSource()).getProperties();
                    ArrayList<String> removedLinks = new ArrayList<String>();
                    for (String propKey : LinkOut.this.cpropKey2EdgeVTF.keySet()) {
                        if (props.keySet().contains(propKey)) {
                            EdgeLinkoutTaskFactory eltf;
                            url = props.getProperty(propKey);
                            if (url.equals((eltf = LinkOut.this.cpropKey2EdgeVTF.get(propKey)).getLink())) continue;
                            eltf.setLink(url);
                            LinkOut.this.cpropKey2EdgeVTF.put(propKey, eltf);
                            continue;
                        }
                        EdgeLinkoutTaskFactory eltf = LinkOut.this.cpropKey2EdgeVTF.get(propKey);
                        LinkOut.this.registrar.unregisterService((Object)eltf, EdgeViewTaskFactory.class);
                        removedLinks.add(propKey);
                    }
                    for (String propKey : LinkOut.this.cpropKey2NodeVTF.keySet()) {
                        if (props.keySet().contains(propKey)) {
                            NodeLinkoutTaskFactory nltf;
                            url = props.getProperty(propKey);
                            if (url.equals((nltf = LinkOut.this.cpropKey2NodeVTF.get(propKey)).getLink())) continue;
                            nltf.setLink(url);
                            LinkOut.this.cpropKey2NodeVTF.put(propKey, nltf);
                            continue;
                        }
                        NodeLinkoutTaskFactory nltf = LinkOut.this.cpropKey2NodeVTF.get(propKey);
                        LinkOut.this.registrar.unregisterService((Object)nltf, NodeViewTaskFactory.class);
                        removedLinks.add(propKey);
                    }
                    for (String propkey : removedLinks) {
                        LinkOut.this.cpropKey2EdgeVTF.remove(propkey);
                        LinkOut.this.cpropKey2NodeVTF.remove(propkey);
                    }
                    try {
                        Properties dict;
                        String url3;
                        String propKey;
                        for (Object pk : props.keySet()) {
                            propKey = pk.toString();
                            if (LinkOut.this.cpropKey2EdgeVTF.containsKey(propKey)) continue;
                            url3 = props.getProperty(propKey);
                            dict = LinkOut.this.createProperties(propKey, LinkOut.EDGEMARKER);
                            if (url3 == null || dict == null) {
                                logger.debug("Bad URL for propKey: " + propKey);
                                continue;
                            }
                            EdgeLinkoutTaskFactory evtf = new EdgeLinkoutTaskFactory(browser, url3);
                            LinkOut.this.registrar.registerService((Object)evtf, EdgeViewTaskFactory.class, dict);
                            LinkOut.this.cpropKey2EdgeVTF.put(propKey, evtf);
                        }
                        for (Object pk : props.keySet()) {
                            propKey = pk.toString();
                            if (LinkOut.this.cpropKey2NodeVTF.containsKey(propKey)) continue;
                            url3 = props.getProperty(propKey);
                            dict = LinkOut.this.createProperties(propKey, LinkOut.NODEMARKER);
                            if (url3 == null || dict == null) {
                                logger.debug("Bad URL for propKey: " + propKey);
                                continue;
                            }
                            NodeLinkoutTaskFactory nvtf = new NodeLinkoutTaskFactory(browser, url3);
                            LinkOut.this.registrar.registerService((Object)nvtf, NodeViewTaskFactory.class, dict);
                            LinkOut.this.cpropKey2NodeVTF.put(propKey, nvtf);
                        }
                    }
                    catch (Exception ex) {
                        logger.warn("Problem processing node URLs", (Throwable)ex);
                    }
                }
            }
        });
    }
}

