/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.cytoscape.view.table.internal.util.ViewUtil;

public class BrowserTableRowHeaderRenderer
extends JLabel
implements ListCellRenderer<Integer> {
    private static final int SELECTION_WIDTH = 2;
    private boolean isRowSelected;
    private final Color defBgColor;
    private final Color selBgColor;
    private final JTable table;

    public BrowserTableRowHeaderRenderer(JTable table) {
        this.table = table;
        this.defBgColor = ViewUtil.getDefaultTableHeaderBg();
        this.selBgColor = ViewUtil.getSelectedTableHeaderBg();
        this.setText("");
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setOpaque(true);
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.setBorder(UIManager.getBorder("TableRowHeader.cellBorder"));
        this.setFont(UIManager.getFont("TableHeader.font"));
        this.setDoubleBuffered(true);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Integer> list, Integer value, int index, boolean isSelected, boolean hasFocus) {
        this.isRowSelected = this.table.isRowSelected(index);
        this.setBackground(isSelected ? this.selBgColor : this.defBgColor);
        this.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), this.table.getRowHeight(index)));
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isRowSelected) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(UIManager.getColor("Table.focusCellBackground"));
            int w = this.getWidth();
            int h = this.getHeight();
            g2.fillRect(w - 2, 0, 2, h);
            g2.dispose();
        }
    }
}

