/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.cytoscape.application.swing.CyColumnPresentation;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.view.table.internal.impl.BrowserTableModel;
import org.cytoscape.view.table.internal.util.ViewUtil;

final class BrowserTableHeaderRenderer
extends JPanel
implements TableCellRenderer {
    private static final int SELECTION_WIDTH = 2;
    private final JLabel namespaceLabel;
    private final JLabel namespaceIconLabel;
    private final JLabel nameLabel;
    private final JLabel pkLabel;
    private final JLabel sharedLabel;
    private final JLabel immutableLabel;
    private final JLabel sortLabel;
    private boolean isColumnSelected;
    private final Color defBgColor;
    private final Color selBgColor;
    private final CyServiceRegistrar serviceRegistrar;

    BrowserTableHeaderRenderer(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        IconManager iconManager = (IconManager)serviceRegistrar.getService(IconManager.class);
        this.defBgColor = ViewUtil.getDefaultTableHeaderBg();
        this.selBgColor = ViewUtil.getSelectedTableHeaderBg();
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.namespaceLabel = new JLabel();
        this.namespaceLabel.setFont(UIManager.getFont("TableHeader.font"));
        this.namespaceLabel.setHorizontalAlignment(0);
        this.namespaceLabel.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.namespaceIconLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.nameLabel.setFont(UIManager.getFont("TableHeader.font"));
        this.nameLabel.setHorizontalAlignment(0);
        this.nameLabel.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.pkLabel = new JLabel("\uf084");
        this.pkLabel.setFont(iconManager.getIconFont(12.0f));
        this.pkLabel.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        this.sharedLabel = new JLabel("\uf0e8");
        this.sharedLabel.setFont(iconManager.getIconFont(12.0f));
        this.sharedLabel.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        this.immutableLabel = new JLabel("\uf023");
        this.immutableLabel.setFont(iconManager.getIconFont(14.0f));
        this.immutableLabel.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        this.sortLabel = new JLabel("\uf106");
        this.sortLabel.setFont(iconManager.getIconFont(12.0f));
        this.sortLabel.setMinimumSize(this.sortLabel.getPreferredSize());
        this.sortLabel.setSize(this.sortLabel.getPreferredSize());
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "South");
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.namespaceIconLabel).addGroup(layout.createSequentialGroup().addComponent(this.pkLabel).addComponent(this.sharedLabel).addComponent(this.immutableLabel))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.namespaceLabel, -1, -1, Short.MAX_VALUE).addComponent(this.nameLabel, -1, -1, Short.MAX_VALUE)).addComponent(this.sortLabel).addGap(4));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.namespaceIconLabel).addComponent(this.namespaceLabel)).addGap(2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pkLabel).addComponent(this.sharedLabel).addComponent(this.immutableLabel).addComponent(this.nameLabel).addComponent(this.sortLabel)).addGap(2));
    }

    private Icon getNamespaceIcon(String namespace) {
        CyColumnPresentationManager presentationManager = (CyColumnPresentationManager)this.serviceRegistrar.getService(CyColumnPresentationManager.class);
        CyColumnPresentation presentation = presentationManager.getColumnPresentation(namespace);
        if (presentation == null) {
            return null;
        }
        Icon icon = presentation.getNamespaceIcon();
        if (icon == null) {
            return null;
        }
        return IconManager.resizeIcon((Icon)icon, (int)16);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.isColumnSelected = Arrays.binarySearch(table.getColumnModel().getSelectedColumns(), col) >= 0;
        boolean isAllRowsSelected = table.getSelectedRowCount() == table.getRowCount();
        this.setBackground(this.isColumnSelected && isAllRowsSelected ? this.selBgColor : this.defBgColor);
        String colName = value != null ? value.toString() : "";
        String[] parts = CyColumn.splitColumnName((String)colName);
        String namespace = parts[0];
        if (namespace == null) {
            this.namespaceLabel.setVisible(false);
            this.namespaceIconLabel.setVisible(false);
        } else {
            this.namespaceLabel.setVisible(true);
            this.namespaceLabel.setText(namespace);
            Icon icon = this.getNamespaceIcon(namespace);
            if (icon == null) {
                this.namespaceIconLabel.setVisible(false);
            } else {
                this.namespaceIconLabel.setVisible(true);
                this.namespaceIconLabel.setIcon(icon);
            }
        }
        Font font = this.nameLabel.getFont();
        this.nameLabel.setFont(colName.equals("SUID") ? font.deriveFont(1) : font.deriveFont(0));
        this.nameLabel.setText(parts[1]);
        this.pkLabel.setVisible(false);
        this.sharedLabel.setVisible(false);
        this.immutableLabel.setVisible(false);
        this.sortLabel.setText(" ");
        this.sortLabel.setForeground(UIManager.getColor("TextField.inactiveForeground"));
        this.setToolTipText(colName);
        if (!(table.getModel() instanceof BrowserTableModel)) {
            this.invalidate();
            return this;
        }
        BrowserTableModel model = (BrowserTableModel)table.getModel();
        CyColumn column = model.getDataTable().getColumn(colName);
        if (column != null) {
            RowSorter.SortKey key;
            StringBuilder toolTip = new StringBuilder("<html><div style='text-align: center;'>");
            if (colName.equals("SUID")) {
                toolTip.append("Session-Unique ID");
            } else if (column.getType() == List.class) {
                toolTip.append("<b>").append(column.getName()).append("</b><br /><font face='monospace'>(List of ").append(this.getMinimizedType(column.getListElementType().getName())).append("s)</font>");
            } else {
                toolTip.append("<b>").append(column.getName()).append("</b><br /><font face='monospace'>(").append(this.getMinimizedType(column.getType().getName())).append(")</font>");
            }
            toolTip.append("</div>");
            if (column.getVirtualColumnInfo().isVirtual() || column.isImmutable() || column.isPrimaryKey()) {
                toolTip.append("<hr noshade />");
                if (column.isPrimaryKey()) {
                    toolTip.append("<p>- <i>Primary Key</i></p>");
                    this.pkLabel.setVisible(true);
                }
                if (column.getVirtualColumnInfo().isVirtual()) {
                    toolTip.append("<p>- <i>Network Collection Column</i></p>");
                    this.sharedLabel.setVisible(true);
                }
                if (column.isImmutable() || column.isPrimaryKey()) {
                    toolTip.append("<p>- Column cannot be: ");
                    if (column.isImmutable()) {
                        toolTip.append("deleted, renamed");
                        if (column.isPrimaryKey()) {
                            toolTip.append(",");
                        }
                        this.immutableLabel.setVisible(true);
                    }
                    if (column.isPrimaryKey()) {
                        toolTip.append(" edited");
                    }
                    toolTip.append("</p>");
                }
            }
            toolTip.append("</html>");
            this.setToolTipText(toolTip.toString());
            int index = -1;
            boolean ascending = true;
            RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
            int modelColumn = col >= 0 && col < table.getColumnCount() ? table.convertColumnIndexToModel(col) : -1;
            List<RowSorter.SortKey> sortKeys = rowSorter.getSortKeys();
            if (sortKeys.size() > 0 && (key = sortKeys.get(0)).getColumn() == modelColumn) {
                index = col;
                boolean bl = ascending = key.getSortOrder() == SortOrder.ASCENDING;
            }
            if (col == index) {
                this.sortLabel.setText(ascending ? "\uf106" : "\uf107");
            }
            if (col == index) {
                this.sortLabel.setForeground(UIManager.getColor("TableHeader.foreground"));
            }
        }
        this.invalidate();
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isColumnSelected) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setColor(UIManager.getColor("Table.focusCellBackground"));
            int w = this.getWidth();
            int h = this.getHeight();
            g2.fillRect(0, h - 2, w, 2);
            g2.dispose();
        }
    }

    private String getMinimizedType(String type) {
        return type.substring(type.lastIndexOf(46) + 1);
    }
}

