/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.ColumnNameChangedListener;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.ColumnResizer;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextWrapToolTip;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.events.AboutToRemoveColumnViewEvent;
import org.cytoscape.view.model.events.AboutToRemoveColumnViewListener;
import org.cytoscape.view.model.events.AddedColumnViewEvent;
import org.cytoscape.view.model.events.AddedColumnViewListener;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.view.presentation.property.table.TableMode;
import org.cytoscape.view.table.internal.impl.BrowserTableCellRenderer;
import org.cytoscape.view.table.internal.impl.BrowserTableColumnModel;
import org.cytoscape.view.table.internal.impl.BrowserTableHeaderRenderer;
import org.cytoscape.view.table.internal.impl.BrowserTableModel;
import org.cytoscape.view.table.internal.impl.MultiLineTableCellEditor;
import org.cytoscape.view.table.internal.impl.PopupMenuHelper;
import org.cytoscape.view.table.internal.util.TableBrowserUtil;
import org.cytoscape.view.table.internal.util.ValidatedObjectAndEditString;
import org.cytoscape.view.table.internal.util.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserTable
extends JTable
implements MouseListener,
ActionListener,
MouseMotionListener,
AboutToRemoveColumnViewListener,
AddedColumnViewListener,
ColumnNameChangedListener,
RowsSetListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final Font BORDER_FONT = UIManager.getFont("Label.font").deriveFont(LookAndFeelUtil.getSmallFontSize());
    private CellEditorRemover editorRemover;
    private final TableCellRenderer cellRenderer;
    private final HashMap<String, Integer> columnWidthMap = new HashMap();
    private JPopupMenu popupMenu;
    private JMenuItem openFormulaBuilderMenuItem;
    private MultiLineTableCellEditor multiLineCellEditor;
    private final PopupMenuHelper popupMenuHelper;
    private final CyServiceRegistrar serviceRegistrar;
    private boolean columnWidthChanged;
    private boolean ignoreColumnSelectionEvents;
    private boolean ignoreRowSelectionEvents;
    private boolean ignoreRowSetEvents;
    private int tempFocusedRow = -1;
    private int tempFocusedColumn = -1;

    public BrowserTable(PopupMenuHelper popupMenuHelper, CyServiceRegistrar serviceRegistrar) {
        this.popupMenuHelper = popupMenuHelper;
        this.serviceRegistrar = serviceRegistrar;
        this.cellRenderer = new BrowserTableCellRenderer(serviceRegistrar);
        this.multiLineCellEditor = new MultiLineTableCellEditor();
        this.init();
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        BrowserTableColumnModel columnModel = new BrowserTableColumnModel();
        this.setColumnModel(columnModel);
        if (dataModel instanceof BrowserTableModel) {
            BrowserTableModel model = (BrowserTableModel)dataModel;
            CyTableView tableView = model.getTableView();
            if (tableView.isSet(BasicTableVisualLexicon.TABLE_ROW_HEIGHT)) {
                this.setRowHeight((Integer)tableView.getVisualProperty(BasicTableVisualLexicon.TABLE_ROW_HEIGHT));
            }
            this.setShowGrid(Boolean.TRUE.equals(tableView.getVisualProperty(BasicTableVisualLexicon.TABLE_GRID_VISIBLE)));
            for (int i = 0; i < model.getColumnCount(); ++i) {
                String name = model.getColumnName(i);
                View view = tableView.getColumnView(name);
                boolean visible = (Boolean)view.getVisualProperty(BasicTableVisualLexicon.COLUMN_VISIBLE);
                double gravity = (Double)view.getVisualProperty(BasicTableVisualLexicon.COLUMN_GRAVITY);
                TableColumn tableColumn = new TableColumn(i);
                tableColumn.setHeaderValue(name);
                tableColumn.setHeaderRenderer(new BrowserTableHeaderRenderer(this.serviceRegistrar));
                columnModel.addColumn(tableColumn, view.getSUID(), visible, gravity);
            }
            View view = tableView.getColumnView("selected");
            if (view != null && !view.isSet(BasicTableVisualLexicon.COLUMN_EDITABLE)) {
                view.setLockedValue(BasicTableVisualLexicon.COLUMN_EDITABLE, (Object)false);
            }
            BrowserTableModel.ViewMode viewMode = BrowserTableModel.ViewMode.fromVisualPropertyValue((TableMode)tableView.getVisualProperty(BasicTableVisualLexicon.TABLE_VIEW_MODE));
            model.setViewMode(viewMode);
            model.updateViewMode();
        }
        columnModel.reorderColumnsToRespectGravity();
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        if (columnModel != this.getColumnModel()) {
            super.setColumnModel(columnModel);
            columnModel.getSelectionModel().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting() && !this.ignoreColumnSelectionEvents) {
                    this.setColumnSelectedVP(e.getFirstIndex(), e.getLastIndex());
                }
            });
        }
    }

    @Override
    public void setShowGrid(boolean showGrid) {
        if (showGrid) {
            Color color = UIManager.getColor("Table.gridColor");
            if (color == null) {
                color = UIManager.getColor("Separator.foreground");
            }
            if (color.getAlpha() == 0) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
            }
            this.setGridColor(color);
        }
        super.setShowGrid(showGrid);
    }

    public BrowserTableModel getBrowserTableModel() {
        return this.getModel() instanceof BrowserTableModel ? (BrowserTableModel)this.getModel() : null;
    }

    @Override
    public void selectAll() {
        super.selectAll();
        int columnCount = this.getColumnModel().getColumnCount();
        int rowCount = this.getRowCount();
        if (columnCount > 0) {
            this.getColumnModel().getSelectionModel().addSelectionInterval(0, columnCount - 1);
        }
        if (rowCount > 0) {
            this.getSelectionModel().addSelectionInterval(0, rowCount - 1);
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener listener) {
        super.addMouseListener(new ProxyMouseListener(listener));
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.cellRenderer;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (super.isCellEditable(row, column)) {
            BrowserTableModel tableModel = this.getBrowserTableModel();
            if (tableModel != null) {
                CyTableView tableView = tableModel.getTableView();
                String name = this.getColumnName(column);
                View view = tableView.getColumnView(name);
                return Boolean.TRUE.equals(view.getVisualProperty(BasicTableVisualLexicon.COLUMN_EDITABLE));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean editCellAt(final int row, final int column, EventObject e) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        final TableCellEditor editor = this.getCellEditor(row, column);
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return false;
        }
        CyRow cyRow = tableModel.getCyRow(this.convertRowIndexToModel(row));
        String columnName = tableModel.getColumnName(this.convertColumnIndexToModel(column));
        this.editorRemover.setCellData(cyRow, columnName);
        if (editor != null && editor.isCellEditable(e)) {
            this.setEditingRow(row);
            this.setEditingColumn(column);
            this.setCellEditor(editor);
            editor.addCellEditorListener(this);
            this.editorComp = this.prepareEditor(editor, row, column);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            Rectangle cellRect = this.getCellRect(row, column, false);
            if (editor instanceof MultiLineTableCellEditor) {
                Dimension prefSize = this.editorComp.getPreferredSize();
                ((JComponent)this.editorComp).putClientProperty("UpdateBounds", Boolean.TRUE);
                this.editorComp.setBounds(cellRect.x, cellRect.y, Math.max(cellRect.width, prefSize.width), Math.max(cellRect.height, prefSize.height));
                ((JComponent)this.editorComp).putClientProperty("UpdateBounds", Boolean.FALSE);
            } else {
                this.editorComp.setBounds(cellRect);
            }
            this.editorComp.addKeyListener(new KeyListener(){

                private void deselect(KeyEvent e) {
                    e.consume();
                    Component comp = e.getComponent();
                    comp.removeKeyListener(this);
                    editor.stopCellEditing();
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void keyPressed(KeyEvent event) {
                    int newRow = row;
                    int newColumn = column;
                    int modifiers = event.getModifiersEx();
                    if (event.getKeyCode() == 10) {
                        if (modifiers == 0) {
                            ++newRow;
                        } else {
                            if (modifiers != 16) return;
                            --newRow;
                        }
                    } else {
                        if (event.getKeyCode() != 9) return;
                        if (modifiers == 0) {
                            ++newColumn;
                        } else {
                            if (modifiers != 16) return;
                            --newColumn;
                        }
                    }
                    this.deselect(event);
                    BrowserTable.this.changeSelection(newRow, newColumn, false, false);
                }
            });
            this.add(this.editorComp);
            this.editorComp.validate();
            return true;
        }
        return false;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        super.columnAdded(e);
        if (this.getParent() == null) {
            return;
        }
        int colIdx = e.getToIndex();
        this.syncColumnWidth(colIdx);
        this.resizeAndRepaint();
        this.scrollRectToVisible(this.getCellRect(0, colIdx, true));
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        super.columnRemoved(e);
        this.resetRowHeight();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.syncColumnWidth(i);
        }
        this.resizeAndRepaint();
    }

    @Override
    public void setRowHeight(int row, int rowHeight) {
        CyRow cyRow;
        int old = this.getRowHeight(row);
        if (rowHeight == old) {
            return;
        }
        super.setRowHeight(row, rowHeight);
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return;
        }
        CyTableView tableView = tableModel.getTableView();
        View rowView = tableView.getRowView(cyRow = tableModel.getCyRow(this.convertRowIndexToModel(row)));
        if (!rowView.isSet(BasicTableVisualLexicon.ROW_HEIGHT) || rowHeight != (Integer)rowView.getVisualProperty(BasicTableVisualLexicon.ROW_HEIGHT)) {
            rowView.setLockedValue(BasicTableVisualLexicon.ROW_HEIGHT, (Object)rowHeight);
            ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).flushPayloadEvents();
        }
        this.fireRowHeightChange(old, rowHeight);
    }

    @Override
    public JToolTip createToolTip() {
        TextWrapToolTip tip = new TextWrapToolTip();
        tip.setMaximumSize(new Dimension(480, 320));
        tip.setComponent((JComponent)this);
        return tip;
    }

    public void showListContents(int modelRow, int modelColumn, MouseEvent e) {
        List list;
        ValidatedObjectAndEditString value;
        Class columnType;
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return;
        }
        Class clazz = columnType = modelColumn >= 0 && modelColumn < tableModel.getColumnCount() ? tableModel.getCyColumn(modelColumn).getType() : null;
        if (columnType == List.class && (value = (ValidatedObjectAndEditString)tableModel.getValueAt(modelRow, modelColumn)) != null && (list = (List)value.getValidatedObject()) != null && !list.isEmpty()) {
            this.showCellMenu(List.class, list, "Entries", e);
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu != null) {
            return this.popupMenu;
        }
        this.popupMenu = new JPopupMenu();
        this.openFormulaBuilderMenuItem = new JMenuItem("Open Formula Builder");
        BrowserTable table = this;
        this.openFormulaBuilderMenuItem.addActionListener(evt -> {
            int cellRow = table.getSelectedRow();
            int cellColumn = table.getSelectedColumn();
            BrowserTableModel tableModel = this.getBrowserTableModel();
            if (tableModel == null) {
                return;
            }
            JFrame rootFrame = (JFrame)SwingUtilities.getRoot(table);
            if (cellRow == -1 || cellColumn == -1 || !tableModel.isCellEditable(cellRow, cellColumn)) {
                JOptionPane.showMessageDialog(rootFrame, "Can't enter a formula w/o a selected cell.", "Information", 1);
            }
        });
        return this.popupMenu;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.getSelectedRows().length != 0) {
            int viewColumn = this.getColumnModel().getColumnIndexAtX(e.getX());
            int viewRow = this.rowAtPoint(e.getPoint());
            int modelColumn = this.convertColumnIndexToModel(viewColumn);
            int modelRow = this.convertRowIndexToModel(viewRow);
            BrowserTableModel tableModel = (BrowserTableModel)this.getModel();
            if (tableModel.isPrimaryKey(modelColumn)) {
                return;
            }
            if (modelColumn >= tableModel.getColumnCount() || modelRow >= tableModel.getRowCount()) {
                return;
            }
            this.showListContents(modelRow, modelColumn, e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int index;
        if (e.getSource() instanceof JTableHeader && (index = this.getColumnModel().getColumnIndexAtX(e.getX())) != -1) {
            int colWidth = this.getColumnModel().getColumn(index).getWidth();
            this.columnWidthMap.put(this.getColumnName(index), colWidth);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        super.columnMarginChanged(e);
        if (!this.isColumnWidthChanged() && this.getTableHeader().getResizingColumn() != null) {
            this.setColumnWidthChanged(true);
        }
    }

    public boolean isColumnWidthChanged() {
        return this.columnWidthChanged;
    }

    public void setColumnWidthChanged(boolean b) {
        this.columnWidthChanged = b;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().compareTo("Copy") == 0) {
            this.copyToClipboard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            super.paint(g);
            return;
        }
        ReadWriteLock lock = tableModel.getLock();
        lock.readLock().lock();
        try {
            if (!tableModel.isDisposed()) {
                super.paint(g);
            }
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public void handleEvent(AddedColumnViewEvent e) {
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return;
        }
        CyTableView tableView = tableModel.getTableView();
        if (e.getSource() != tableView) {
            return;
        }
        BrowserTableColumnModel columnModel = (BrowserTableColumnModel)this.getColumnModel();
        CyColumn col = (CyColumn)e.getColumnView().getModel();
        tableModel.addColumn(col.getName());
        int colIndex = columnModel.getColumnCount(false);
        String name = col.getName();
        View view = tableModel.getTableView().getColumnView(name);
        boolean visible = (Boolean)view.getVisualProperty(BasicTableVisualLexicon.COLUMN_VISIBLE);
        double gravity = (Double)view.getVisualProperty(BasicTableVisualLexicon.COLUMN_GRAVITY);
        TableColumn tableColumn = new TableColumn(colIndex);
        tableColumn.setHeaderValue(name);
        tableColumn.setHeaderRenderer(new BrowserTableHeaderRenderer(this.serviceRegistrar));
        columnModel.addColumn(tableColumn, view.getSUID(), visible, gravity);
        columnModel.reorderColumnsToRespectGravity();
    }

    public void handleEvent(AboutToRemoveColumnViewEvent e) {
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return;
        }
        CyTableView tableView = tableModel.getTableView();
        if (e.getSource() != tableView) {
            return;
        }
        tableModel.fireTableStructureChanged();
        BrowserTableColumnModel columnModel = (BrowserTableColumnModel)this.getColumnModel();
        String columnName = ((CyColumn)e.getColumnView().getModel()).getName();
        boolean columnFound = false;
        int removedColIndex = -1;
        List<String> attrNames = tableModel.getAllAttributeNames();
        for (int i = 0; i < attrNames.size(); ++i) {
            if (attrNames.get(i).equals(columnName)) {
                removedColIndex = i;
                columnModel.deleteColumn(columnModel.getColumn(this.convertColumnIndexToView(i)));
                columnFound = true;
                continue;
            }
            if (!columnFound) continue;
            TableColumn nextCol = columnModel.getColumnByModelIndex(i);
            nextCol.setModelIndex(i - 1);
        }
        if (removedColIndex != -1) {
            tableModel.removeColumn(removedColIndex);
        }
    }

    public void handleEvent(ColumnNameChangedEvent e) {
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return;
        }
        CyTable dataTable = tableModel.getDataTable();
        if (e.getSource() != dataTable) {
            return;
        }
        this.renameColumnName(e.getOldColumnName(), e.getNewColumnName());
        ViewUtil.invokeOnEDT(() -> this.tableHeader.repaint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(RowsSetEvent e) {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        if (this.ignoreRowSetEvents) {
            return;
        }
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return;
        }
        CyTable dataTable = tableModel.getDataTable();
        if (e.getSource() != dataTable) {
            return;
        }
        if (tableModel.getViewMode() == BrowserTableModel.ViewMode.SELECTED || tableModel.getViewMode() == BrowserTableModel.ViewMode.AUTO) {
            tableModel.clearSelectedRows();
            boolean foundANonSelectedColumnName = false;
            for (String column : e.getColumns()) {
                if ("selected".equals(column)) continue;
                foundANonSelectedColumnName = true;
                break;
            }
            if (!foundANonSelectedColumnName) {
                tableModel.fireTableDataChanged();
                return;
            }
        }
        Collection rows = e.getPayloadCollection();
        BrowserTable browserTable = this;
        synchronized (browserTable) {
            CyTableManager tableManager;
            tableModel.fireTableDataChanged();
            if (tableModel.getViewMode() == BrowserTableModel.ViewMode.ALL && !(tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).getGlobalTables().contains(dataTable)) {
                this.bulkUpdate(rows);
            }
        }
    }

    public void resetRowHeight() {
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return;
        }
        CyTableView tableView = tableModel.getTableView();
        int h = (Integer)tableView.getVisualProperty(BasicTableVisualLexicon.TABLE_ROW_HEIGHT);
        if (h > 0) {
            this.setRowHeight(h);
            this.resizeAndRepaint();
            this.fireRowHeightChange(0, h);
        }
    }

    public void fireRowHeightChange(int oldValue, int newValue) {
        this.firePropertyChange("rowHeightChanged", oldValue, newValue);
    }

    public int getTempFocusedRow() {
        return this.tempFocusedRow;
    }

    public int getTempFocusedColumn() {
        return this.tempFocusedColumn;
    }

    protected void init() {
        this.setAutoCreateColumnsFromModel(false);
        this.setAutoCreateRowSorter(true);
        this.setCellSelectionEnabled(true);
        this.setShowGrid((Boolean)BasicTableVisualLexicon.TABLE_GRID_VISIBLE.getDefault());
        this.setDefaultEditor(Object.class, this.multiLineCellEditor);
        this.getPopupMenu();
        this.setKeyStroke();
        this.setTransferHandler(new BrowserTableTransferHandler());
        JTableHeader header = new JTableHeader(){

            @Override
            public void setDraggedColumn(TableColumn column) {
                int idx;
                boolean finished = this.draggedColumn != null && column == null;
                Object colId = this.draggedColumn != null ? this.draggedColumn.getIdentifier() : null;
                super.setDraggedColumn(column);
                if (finished && (idx = this.getColumnModel().getColumnIndex(colId)) >= 0) {
                    BrowserTable.this.setSelectedColumn(idx);
                }
            }
        };
        header.setOpaque(false);
        header.getColumnModel().setColumnSelectionAllowed(true);
        header.addMouseMotionListener(this);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BrowserTable.this.maybeShowHeaderPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BrowserTable.this.maybeShowHeaderPopup(e);
                } else if (BrowserTable.this.isColumnWidthChanged()) {
                    BrowserTable.this.setColumnWidthChanged(false);
                    BrowserTableModel tableModel = BrowserTable.this.getBrowserTableModel();
                    if (tableModel == null) {
                        return;
                    }
                    BrowserTableColumnModel columnModel = (BrowserTableColumnModel)BrowserTable.this.getColumnModel();
                    CyTableView tableView = tableModel.getTableView();
                    for (int i = 0; i < BrowserTable.this.getColumnCount(); ++i) {
                        String name;
                        View view;
                        Integer oldWidth;
                        TableColumn column = columnModel.getColumn(i);
                        int newWidth = column.getWidth();
                        if (newWidth <= 0 || (oldWidth = (Integer)(view = tableView.getColumnView(name = tableModel.getColumnName(BrowserTable.this.convertColumnIndexToModel(i)))).getVisualProperty(BasicTableVisualLexicon.COLUMN_WIDTH)) != null && newWidth == oldWidth) continue;
                        view.setLockedValue(BasicTableVisualLexicon.COLUMN_WIDTH, (Object)newWidth);
                    }
                }
            }
        });
        this.setTableHeader(header);
        this.setSelectionMode(2);
        this.addMouseListener(this);
        this.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && !this.ignoreRowSelectionEvents) {
                this.selectFromTable();
                BrowserTableModel tableModel = this.getBrowserTableModel();
                if (tableModel != null) {
                    CyTableView tableView = tableModel.getTableView();
                    boolean changed = false;
                    for (int idx = e.getFirstIndex(); idx <= e.getLastIndex(); ++idx) {
                        if (idx >= this.getRowCount()) continue;
                        CyRow cyRow = tableModel.getCyRow(this.convertRowIndexToModel(idx));
                        View rowView = tableView.getRowView(cyRow);
                        boolean selected = this.isRowSelected(idx);
                        if (selected == (Boolean)rowView.getVisualProperty(BasicTableVisualLexicon.ROW_SELECTED)) continue;
                        rowView.setLockedValue(BasicTableVisualLexicon.ROW_SELECTED, (Object)selected);
                        changed = true;
                    }
                    if (changed) {
                        ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).flushPayloadEvents();
                    }
                }
            }
        });
    }

    private void setSelectedColumn(int idx) {
        this.ignoreColumnSelectionEvents = true;
        try {
            this.getColumnModel().getSelectionModel().clearSelection();
            this.addColumnSelectionInterval(idx, idx);
            if (this.getRowCount() > 0) {
                this.addRowSelectionInterval(0, this.getRowCount() - 1);
            }
        }
        finally {
            this.ignoreColumnSelectionEvents = false;
        }
        this.setColumnSelectedVP(0, this.getColumnCount() - 1);
    }

    private void setColumnSelectedVP(int firstIndex, int lastIndex) {
        if (lastIndex < firstIndex) {
            throw new IllegalArgumentException("'lastIndex' must not be greater than 'firstIndex'.");
        }
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel != null) {
            CyTableView tableView = tableModel.getTableView();
            boolean changed = false;
            for (int idx = firstIndex; idx <= lastIndex; ++idx) {
                if (idx >= this.getColumnCount()) continue;
                CyColumn cyColumn = tableModel.getCyColumn(this.convertColumnIndexToModel(idx));
                if (cyColumn == null) {
                    return;
                }
                View columnView = tableView.getColumnView(cyColumn);
                boolean selected = this.isColumnSelected(idx);
                if (selected == (Boolean)columnView.getVisualProperty(BasicTableVisualLexicon.COLUMN_SELECTED)) continue;
                columnView.setLockedValue(BasicTableVisualLexicon.COLUMN_SELECTED, (Object)selected);
                changed = true;
            }
            if (changed) {
                ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).flushPayloadEvents();
            }
        }
    }

    private void syncColumnWidth(int idx) {
        String name;
        if (idx < 0) {
            return;
        }
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return;
        }
        BrowserTableColumnModel columnModel = (BrowserTableColumnModel)this.getColumnModel();
        TableColumn column = columnModel.getColumn(idx);
        CyTableView tableView = tableModel.getTableView();
        View columnView = tableView.getColumnView(name = tableModel.getColumnName(this.convertColumnIndexToModel(idx)));
        if (columnView.isSet(BasicTableVisualLexicon.COLUMN_WIDTH)) {
            int oldWidth = column.getWidth();
            Integer newWidth = (Integer)columnView.getVisualProperty(BasicTableVisualLexicon.COLUMN_WIDTH);
            if (newWidth != null && newWidth > 0 && newWidth != oldWidth) {
                column.setPreferredWidth(newWidth);
                column.setWidth(newWidth);
            }
        } else {
            ColumnResizer.adjustColumnPreferredWidth((JTable)this, (int)idx, (boolean)false);
            columnView.setLockedValue(BasicTableVisualLexicon.COLUMN_WIDTH, (Object)column.getWidth());
        }
    }

    private void setKeyStroke() {
        int modifiers = LookAndFeelUtil.isMac() ? 4 : 2;
        KeyStroke copy = KeyStroke.getKeyStroke(67, modifiers, false);
        this.registerKeyboardAction(this, "Copy", copy, 0);
    }

    private void showCellMenu(Class<?> type, List<?> listItems, String borderTitle, MouseEvent e) {
        JPopupMenu cellMenu = new JPopupMenu();
        TitledBorder popupBorder = BorderFactory.createTitledBorder(null, borderTitle, 0, 0, BORDER_FONT);
        cellMenu.setBorder(popupBorder);
        JMenu curItem = null;
        Object dispName = null;
        for (Object item : listItems) {
            dispName = item.toString();
            if (((String)dispName).length() > 60) {
                dispName = ((String)dispName).substring(0, 59) + " ...";
            }
            curItem = new JMenu((String)dispName);
            curItem.add(this.getPopupMenu());
            JMenuItem copyAll = new JMenuItem("Copy all entries");
            copyAll.addActionListener(evt -> {
                StringBuilder builder = new StringBuilder();
                for (Object oneEntry : listItems) {
                    builder.append(oneEntry.toString() + "\t");
                }
                StringSelection selection = new StringSelection(builder.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            });
            curItem.add(copyAll);
            JMenuItem copy = new JMenuItem("Copy this entry");
            copy.addActionListener(evt -> {
                StringSelection selection = new StringSelection(item.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            });
            curItem.add(copy);
            if (dispName != null && (((String)dispName).startsWith("http:") || ((String)dispName).startsWith("https:"))) {
                curItem.add(this.popupMenuHelper.getOpenLinkMenu(dispName));
            }
            cellMenu.add(curItem);
        }
        cellMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void maybeShowHeaderPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            BrowserTableModel tableModel;
            int column = this.getColumnModel().getColumnIndexAtX(e.getX());
            if (column >= 0) {
                this.setSelectedColumn(column);
            }
            if ((tableModel = this.getBrowserTableModel()) == null || column >= tableModel.getColumnCount() || column < 0) {
                return;
            }
            if (tableModel.isPrimaryKey(this.convertColumnIndexToModel(column))) {
                return;
            }
            CyNetworkTableManager networkTableManager = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
            Class tableType = networkTableManager.getTableType(tableModel.getDataTable());
            CyColumn cyColumn = tableModel.getCyColumn(this.convertColumnIndexToModel(column));
            this.popupMenuHelper.createColumnHeaderMenu(cyColumn, tableType, this, e.getX(), e.getY(), this);
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.selectFocusedCell(e);
            int viewColumn = this.getColumnModel().getColumnIndexAtX(e.getX());
            int viewRow = this.rowAtPoint(e.getPoint());
            int modelColumn = this.convertColumnIndexToModel(viewColumn);
            int modelRow = this.convertRowIndexToModel(viewRow);
            BrowserTableModel tableModel = this.getBrowserTableModel();
            if (tableModel == null || tableModel.isPrimaryKey(modelColumn)) {
                return;
            }
            if (modelColumn >= tableModel.getColumnCount() || modelRow >= tableModel.getRowCount()) {
                return;
            }
            CyColumn cyColumn = tableModel.getCyColumn(modelColumn);
            Object primaryKeyValue = ((ValidatedObjectAndEditString)tableModel.getValueAt(modelRow, tableModel.getDataTable().getPrimaryKey().getName())).getValidatedObject();
            CyNetworkTableManager networkTableManager = (CyNetworkTableManager)this.serviceRegistrar.getService(CyNetworkTableManager.class);
            Class tableType = networkTableManager.getTableType(tableModel.getDataTable());
            JPopupMenu menu = this.popupMenuHelper.createTableCellMenu(cyColumn, primaryKeyValue, tableType, this, e.getX(), e.getY(), this);
            menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    this.resetTempFocusedCell();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    this.resetTempFocusedCell();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                private void resetTempFocusedCell() {
                    BrowserTable.this.tempFocusedRow = -1;
                    BrowserTable.this.tempFocusedColumn = -1;
                    BrowserTable.this.repaint();
                }
            });
        }
    }

    private void selectFocusedCell(MouseEvent e) {
        boolean isColumnSelected;
        int row = this.tempFocusedRow = this.rowAtPoint(e.getPoint());
        int column = this.tempFocusedColumn = this.getColumnModel().getColumnIndexAtX(e.getX());
        int[] selectedRows = this.getSelectedRows();
        boolean isRowselected = Arrays.binarySearch(selectedRows, row) >= 0;
        boolean bl = isColumnSelected = Arrays.binarySearch(this.getColumnModel().getSelectedColumns(), column) >= 0;
        if (isRowselected && isColumnSelected) {
            this.repaint();
        } else {
            this.changeSelection(row, column, false, false);
        }
    }

    private void copyToClipboard() {
        String data = BrowserTable.createCopyString(this);
        StringSelection selection = new StringSelection(data);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    private void renameColumnName(String oldName, String newName) {
        BrowserTableColumnModel columnModel = (BrowserTableColumnModel)this.getColumnModel();
        BrowserTableModel model = this.getBrowserTableModel();
        int index = model.mapColumnNameToColumnIndex(oldName);
        if (index >= 0) {
            model.setColumnName(index, newName);
            columnModel.getColumn(this.convertColumnIndexToView(index)).setHeaderValue(newName);
            return;
        }
        throw new IllegalStateException("The specified column " + oldName + " does not exist in the model.");
    }

    private void bulkUpdate(Collection<RowSetRecord> rows) {
        HashSet<Long> suidSelected = new HashSet<Long>();
        HashSet<Long> suidUnselected = new HashSet<Long>();
        for (RowSetRecord rowSetRecord : rows) {
            if (!rowSetRecord.getColumn().equals("selected")) continue;
            if (((Boolean)rowSetRecord.getValue()).booleanValue()) {
                suidSelected.add((Long)rowSetRecord.getRow().get("SUID", Long.class));
                continue;
            }
            suidUnselected.add((Long)rowSetRecord.getRow().get("SUID", Long.class));
        }
        this.changeRowSelection(suidSelected, suidUnselected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRowSelection(Set<Long> suidSelected, Set<Long> suidUnselected) {
        BrowserTableModel tableModel = this.getBrowserTableModel();
        if (tableModel == null) {
            return;
        }
        CyTable dataTable = tableModel.getDataTable();
        String pKeyName = dataTable.getPrimaryKey().getName();
        int rowCount = this.getRowCount();
        try {
            this.ignoreRowSelectionEvents = true;
            for (int i = 0; i < rowCount; ++i) {
                int modelRow = this.convertRowIndexToModel(i);
                ValidatedObjectAndEditString tableKey = (ValidatedObjectAndEditString)tableModel.getValueAt(modelRow, pKeyName);
                Long pk = null;
                try {
                    pk = Long.parseLong(tableKey.getEditString());
                }
                catch (NumberFormatException nfe) {
                    logger.error("Error parsing long from table " + this.getName(), (Throwable)nfe);
                }
                if (pk == null) continue;
                if (suidSelected.contains(pk)) {
                    this.addRowSelectionInterval(i, i);
                    continue;
                }
                if (!suidUnselected.contains(pk)) continue;
                this.removeRowSelectionInterval(i, i);
            }
        }
        finally {
            this.ignoreRowSelectionEvents = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectFromTable() {
        TableModel model = this.getModel();
        if (!(model instanceof BrowserTableModel)) {
            return;
        }
        BrowserTableModel btModel = (BrowserTableModel)model;
        if (btModel.getViewMode() != BrowserTableModel.ViewMode.ALL) {
            return;
        }
        CyTable table = btModel.getDataTable();
        CyColumn pKey = table.getPrimaryKey();
        String pKeyName = pKey.getName();
        if (pKey.getType() != Long.class || table.getColumn("selected") == null) {
            return;
        }
        int[] rowsSelected = this.getSelectedRows();
        if (rowsSelected.length == 0) {
            return;
        }
        int selectedRowCount = this.getSelectedRowCount();
        HashSet<CyRow> targetRows = new HashSet<CyRow>();
        for (int i = 0; i < selectedRowCount; ++i) {
            ValidatedObjectAndEditString selected = (ValidatedObjectAndEditString)btModel.getValueAt(this.convertRowIndexToModel(rowsSelected[i]), pKeyName);
            targetRows.add(btModel.getCyRow(selected.getValidatedObject()));
        }
        CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        if (!tableManager.getGlobalTables().contains(table)) {
            List allRows = table.getAllRows();
            try {
                this.ignoreRowSetEvents = true;
                for (CyRow row : allRows) {
                    Boolean val = (Boolean)row.get("selected", Boolean.class);
                    if (targetRows.contains(row)) {
                        row.set("selected", (Object)true);
                        continue;
                    }
                    if (val == null || !val.booleanValue()) continue;
                    row.set("selected", (Object)false);
                }
                CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
                CyNetworkView curView = applicationManager.getCurrentNetworkView();
                if (curView != null) {
                    ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).flushPayloadEvents();
                    curView.updateView();
                }
            }
            finally {
                this.ignoreRowSetEvents = false;
            }
            this.repaint();
        }
    }

    private static String createCopyString(BrowserTable table) {
        int[] rows = table.getSelectedRows();
        int[] columns = table.getSelectedColumns();
        int numRows = rows.length;
        int numCols = columns.length;
        if (numCols == 0 || numRows == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean firstRow = true;
        for (int r : rows) {
            if (!firstRow) {
                sb.append("\n");
            } else {
                firstRow = false;
            }
            boolean firstColumn = true;
            for (int c : columns) {
                if (!firstColumn) {
                    sb.append("\t");
                } else {
                    firstColumn = false;
                }
                Object object = table.getValueAt(r, c);
                if (object instanceof ValidatedObjectAndEditString) {
                    ValidatedObjectAndEditString raw = (ValidatedObjectAndEditString)object;
                    String s = TableBrowserUtil.createCopyString(raw);
                    sb.append(s);
                    continue;
                }
                if (object == null) continue;
                sb.append(object.toString());
            }
        }
        return sb.toString();
    }

    private static class BrowserTableTransferHandler
    extends TransferHandler {
        private BrowserTableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent source) {
            String data = BrowserTable.createCopyString((BrowserTable)source);
            return new StringSelection(data);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    private class CellEditorRemover
    implements PropertyChangeListener {
        private final KeyboardFocusManager focusManager;
        private CyRow cyRow;
        private String columnName;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!BrowserTable.this.isEditing()) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                if (c == BrowserTable.this) {
                    return;
                }
                if (!(c instanceof Window)) continue;
                if (c != SwingUtilities.getRoot(BrowserTable.this)) break;
                try {
                    BrowserTable.this.getCellEditor().stopCellEditing();
                }
                catch (Exception e) {
                    BrowserTable.this.getCellEditor().cancelCellEditing();
                    this.updateAttributeAfterCellLostFocus();
                }
                break;
            }
        }

        public void setCellData(CyRow row, String columnName) {
            this.cyRow = row;
            this.columnName = columnName;
        }

        private void updateAttributeAfterCellLostFocus() {
            List<Object> parsedData = TableBrowserUtil.parseCellInput(this.cyRow.getTable(), this.columnName, MultiLineTableCellEditor.lastValueUserEntered);
            if (parsedData.get(0) != null) {
                this.cyRow.set(this.columnName, MultiLineTableCellEditor.lastValueUserEntered);
            }
        }
    }

    private class ProxyMouseListener
    extends MouseAdapter {
        private final MouseListener listener;

        public ProxyMouseListener(MouseListener listener) {
            this.listener = listener;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.listener instanceof BrowserTable || !e.isPopupTrigger()) {
                this.listener.mouseClicked(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.listener.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.listener.mouseExited(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.listener instanceof BrowserTable || !e.isPopupTrigger()) {
                this.listener.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.listener.mouseReleased(e);
        }
    }
}

