/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import java.util.List;
import java.util.Set;
import javax.swing.text.Segment;
import org.cytoscape.equations.EquationParser;
import org.cytoscape.equations.EquationTokeniser;
import org.cytoscape.equations.Function;
import org.cytoscape.equations.Token;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.TokenMap;

public class EquationTokenMaker
extends AbstractTokenMaker {
    private final CyServiceRegistrar registrar;

    public EquationTokenMaker(CyServiceRegistrar registrar) {
        this.registrar = registrar;
        this.wordsToHighlight = this.getWordsToHighlight();
    }

    public org.fife.ui.rsyntaxtextarea.Token getTokenList(Segment text, int initialTokenType, int startOffset) {
        this.resetTokenList();
        String equation = text.toString();
        EquationTokeniser tokeniser = (EquationTokeniser)this.registrar.getService(EquationTokeniser.class);
        List tokens = tokeniser.getTokenList(equation);
        int offset = text.offset;
        int newStartOffset = startOffset - offset;
        int prevEnd = offset - 1;
        for (Token t : tokens) {
            int tokenType = EquationTokenMaker.getTokenType(t);
            if (tokenType < 0) continue;
            int start = t.getStart() + offset;
            int end = start + t.getLength();
            if (start - prevEnd > 1) {
                int wsStart = prevEnd + 1;
                this.addToken(text, wsStart, start - 1, 21, newStartOffset + wsStart);
            }
            if (tokenType != 0) {
                this.addToken(text, start, end, tokenType, newStartOffset + start);
            }
            prevEnd = end;
        }
        this.addNullToken();
        return this.firstToken;
    }

    public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
        int value;
        if (tokenType == 20 && (value = this.wordsToHighlight.get(segment, start, end)) != -1) {
            tokenType = value;
        }
        super.addToken(segment, start, end, tokenType, startOffset);
    }

    private static int getTokenType(Token token) {
        switch (token.getType()) {
            case ERROR: {
                return 35;
            }
            case CLOSE_BRACE: 
            case CLOSE_PAREN: 
            case COMMA: 
            case OPEN_BRACE: 
            case OPEN_PAREN: 
            case COLON: {
                return 22;
            }
            case AMPERSAND: 
            case PLUS: 
            case MINUS: 
            case DIV: 
            case MUL: 
            case LESS_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_OR_EQUAL: 
            case GREATER_THAN: 
            case NOT_EQUAL: 
            case EQUAL: 
            case CARET: {
                return 23;
            }
            case DOLLAR: 
            case IDENTIFIER: {
                return 20;
            }
            case BOOLEAN_CONSTANT: {
                return 9;
            }
            case FLOAT_CONSTANT: {
                return 11;
            }
            case STRING_CONSTANT: {
                return 13;
            }
            case EOS: {
                return 0;
            }
        }
        return -1;
    }

    public TokenMap getWordsToHighlight() {
        if (this.registrar == null) {
            return null;
        }
        EquationParser parser = (EquationParser)this.registrar.getService(EquationParser.class);
        Set functions = parser.getRegisteredFunctions();
        TokenMap tokenMap = new TokenMap();
        for (Function f : functions) {
            tokenMap.put(f.getName(), 8);
        }
        return tokenMap;
    }
}

