/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.table.internal.equation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.cytoscape.equations.Equation;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.table.internal.equation.EquationEditorPanel;
import org.cytoscape.view.table.internal.equation.InternalResult;

public class ApplyWorker
extends SwingWorker<InternalResult, Void> {
    private final CyServiceRegistrar registrar;
    private final EquationEditorPanel builderPanel;
    private final Equation equation;
    private final CyColumn col;
    private final Collection<CyRow> rows;
    private final boolean insert;

    public ApplyWorker(CyServiceRegistrar registrar, EquationEditorPanel builderPanel, Equation equation, CyColumn col, Collection<CyRow> rows, boolean insert) {
        this.registrar = registrar;
        this.builderPanel = builderPanel;
        this.insert = insert;
        this.equation = equation;
        this.col = col;
        this.rows = rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InternalResult doInBackground() {
        HashSet<String> errors = new HashSet<String>();
        int numErrors = 0;
        CyEventHelper eventHelper = (CyEventHelper)this.registrar.getService(CyEventHelper.class);
        CyTable table = this.col.getTable();
        eventHelper.silenceEventSource((Object)table);
        ArrayList<RowSetRecord> rowsChanged = new ArrayList<RowSetRecord>();
        try {
            for (CyRow row : this.rows) {
                String errorMessage;
                boolean error = false;
                String colName = this.col.getName();
                row.set(colName, (Object)this.equation);
                Object x = null;
                try {
                    x = row.get(colName, this.col.getType());
                }
                catch (Exception e) {
                    error = true;
                    errors.add(e.getMessage());
                }
                if (x == null && (errorMessage = row.getTable().getLastInternalError()) != null && !errorMessage.isBlank()) {
                    error = true;
                    ++numErrors;
                    errors.add(errorMessage);
                }
                if (this.insert) {
                    rowsChanged.add(new RowSetRecord(row, colName, x, (Object)this.equation));
                    continue;
                }
                Object value = error ? null : x;
                row.set(colName, value);
                rowsChanged.add(new RowSetRecord(row, colName, value, value));
            }
        }
        finally {
            eventHelper.unsilenceEventSource((Object)table);
        }
        RowsSetEvent event = new RowsSetEvent(table, rowsChanged);
        eventHelper.fireEvent((CyEvent)event);
        return new InternalResult(errors, numErrors);
    }

    @Override
    protected void done() {
        try {
            InternalResult result = (InternalResult)this.get();
            if (result.errors.isEmpty()) {
                this.builderPanel.getSyntaxPanel().showEvalSuccess(this.rows.size());
            } else {
                this.builderPanel.getSyntaxPanel().showEvalError(this.rows.size(), result.numErrors, result.errors);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return;
        }
    }
}

