/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster.score;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.ConfidenceImpl;
import uk.ac.ebi.enfin.mi.cluster.ClusterServiceException;
import uk.ac.ebi.enfin.mi.cluster.EncoreInteraction;
import uk.ac.ebi.enfin.mi.cluster.InteractionCluster;
import uk.ac.ebi.enfin.mi.cluster.MethodTypePair;
import uk.ac.ebi.enfin.mi.score.ols.MIOntology;
import uk.ac.ebi.enfin.mi.score.scores.MIScore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionClusterScore
extends InteractionCluster {
    private static final Logger logger = Logger.getLogger(InteractionClusterScore.class);
    protected String fileName;
    protected MIOntology MIO = new MIOntology();
    protected Map<String, Float> customOntologyTypeScores = new HashMap<String, Float>();
    protected Map<String, Float> customOntologyMethodScores = new HashMap<String, Float>();
    protected Integer customPublicationNumberWithHighestScore = null;
    protected Float typeWeight = Float.valueOf(1.0f);
    protected Float methodWeight = Float.valueOf(1.0f);
    protected Float publicationWeight = Float.valueOf(1.0f);
    protected String scoreName = "miscore";
    protected MIScore miscore;

    public InteractionClusterScore() {
        super(0, 200);
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(MIScore miScore) {
        super(0, 200);
        this.miscore = miScore;
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(List<BinaryInteraction> binaryInteractionList, String mappingIdDbNames) {
        super(binaryInteractionList, mappingIdDbNames);
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(List<BinaryInteraction> binaryInteractionList) {
        super(binaryInteractionList);
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(InputStream is, boolean hasHeader) throws ClusterServiceException {
        super(is, hasHeader);
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(Reader r, boolean hasHeader) throws ClusterServiceException {
        super(r, hasHeader);
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(Iterator<BinaryInteraction> iterator) throws ClusterServiceException {
        super(iterator);
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(int queryStart, int queryRange) {
        super(queryStart, queryRange);
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(int queryStart, int queryRange, String mappingIdDbNames) {
        super(queryStart, queryRange, mappingIdDbNames);
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(String mappingIdDbNames) {
        super(mappingIdDbNames);
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(List<String> miqlQueries, List<String> querySource, int queryStart, int queryRange) {
        super(queryStart, queryRange);
        if (miqlQueries != null) {
            this.queryAccs = miqlQueries;
        }
        if (querySource != null) {
            this.querySources = querySource;
        }
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(List<String> miqlQueries, List<String> querySource, int queryStart, int queryRange, String mappingIdDbNames) {
        super(queryStart, queryRange, mappingIdDbNames);
        if (miqlQueries != null) {
            this.queryAccs = miqlQueries;
        }
        if (querySource != null) {
            this.querySources = querySource;
        }
        this.miscore = new MIScore();
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    public InteractionClusterScore(List<String> miqlQueries, List<String> querySource, int queryStart, int queryRange, String mappingIdDbNames, MIScore miScore) {
        super(queryStart, queryRange, mappingIdDbNames);
        if (miqlQueries != null) {
            this.queryAccs = miqlQueries;
        }
        if (querySource != null) {
            this.querySources = querySource;
        }
        this.miscore = miScore;
        this.interactionMapping = new HashMap();
        this.interactorMapping = new HashMap();
        this.synonymMapping = new HashMap();
    }

    protected void runService(MIScore scoreGenerator) {
        logger.debug((Object)"runService");
        super.runService();
        this.processScore(scoreGenerator);
    }

    private void processScore(MIScore scoreGenerator) {
        logger.debug((Object)"Create a map of method terms using parent terms");
        ArrayList<String> methodParentTerms = new ArrayList<String>();
        methodParentTerms.add("MI:0013");
        methodParentTerms.add("MI:0090");
        methodParentTerms.add("MI:0254");
        methodParentTerms.add("MI:0255");
        methodParentTerms.add("MI:0401");
        methodParentTerms.add("MI:0428");
        Map mapOfMethodTerms = this.MIO.getMapOfTerms(methodParentTerms);
        logger.debug((Object)"Create a map of type terms using parent terms");
        ArrayList<String> typeParentTerms = new ArrayList<String>();
        typeParentTerms.add("MI:0208");
        typeParentTerms.add("MI:0407");
        Map mapOfTypeTerms = this.MIO.getMapOfTerms(typeParentTerms);
        mapOfTypeTerms.put("MI:0403", new HashMap());
        mapOfTypeTerms.put("MI:0914", new HashMap());
        mapOfTypeTerms.put("MI:0915", new HashMap());
        logger.debug((Object)"Update interactions");
        for (Integer interactionId : this.getInteractionMapping().keySet()) {
            logger.debug((Object)"Get encore interaction object");
            EncoreInteraction eI = (EncoreInteraction)this.getInteractionMapping().get(interactionId);
            logger.debug((Object)"= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =");
            logger.debug((Object)("IntA: " + eI.getInteractorA() + " , IntB: " + eI.getInteractorB()));
            logger.debug((Object)"Find methods and types per publication");
            ArrayList<String> methods = new ArrayList<String>();
            ArrayList<String> types = new ArrayList<String>();
            Map<MethodTypePair, List<String>> methodTypeToPudmed = eI.getMethodTypePairListMap();
            for (MethodTypePair methodType : methodTypeToPudmed.keySet()) {
                List<String> uniquePublications = eI.getMethodTypePairListMap().get(methodType);
                String method = methodType.getMethod();
                String type = methodType.getType();
                for (int i = 0; i < uniquePublications.size(); ++i) {
                    methods.add(method);
                    types.add(type);
                }
            }
            logger.debug((Object)"Calculate number of Pubmed ids");
            int numberOfPubmedIds = eI.getDistinctPublications().size();
            logger.debug((Object)"Calculate confidence score");
            Float scoreResult = Float.valueOf(0.0f);
            if (scoreGenerator != null) {
                scoreGenerator.setTypeWeight(this.typeWeight);
                scoreGenerator.setMethodWeight(this.methodWeight);
                scoreGenerator.setPublicationWeight(this.publicationWeight);
                scoreGenerator.setMethodScore(methods, mapOfMethodTerms, this.customOntologyMethodScores);
                scoreGenerator.setTypeScore(types, mapOfTypeTerms);
                scoreGenerator.setPublicationScore(Integer.valueOf(numberOfPubmedIds), this.customPublicationNumberWithHighestScore);
                scoreResult = scoreGenerator.getScore();
            }
            logger.debug((Object)"Reassign confidence score if it is already present");
            boolean intactPsiscore = false;
            List<Confidence> confidenceValues = eI.getConfidenceValues();
            for (Confidence confidenceValue : confidenceValues) {
                if (confidenceValue.getType() == null) {
                    logger.warn((Object)("Confidence value problem: " + confidenceValue.getValue()));
                    continue;
                }
                if (!confidenceValue.getType().equalsIgnoreCase(this.getScoreName())) continue;
                confidenceValue.setValue(scoreResult.toString());
                intactPsiscore = true;
                break;
            }
            if (intactPsiscore) continue;
            logger.debug((Object)"Set new confidence score");
            ConfidenceImpl confidenceValue = new ConfidenceImpl();
            confidenceValue.setValue(scoreResult.toString());
            confidenceValue.setType(this.getScoreName());
            eI.addConfidenceValue(confidenceValue);
        }
    }

    @Override
    public void runService() {
        if (this.miscore == null) {
            this.miscore = new MIScore();
        }
        this.runService(this.miscore);
    }

    public void saveScoreInMitab(String fileName) throws IOException {
        this.saveResultsInMitab(fileName);
    }

    public double[] getScores() {
        if (this.getInteractionMapping() == null) {
            this.runService();
        }
        int scoreListSize = this.getInteractionMapping().size();
        double[] scores = new double[scoreListSize];
        int i = 0;
        for (EncoreInteraction eI : this.getInteractionMapping().values()) {
            List<Confidence> confidenceValues = eI.getConfidenceValues();
            Double score = null;
            for (Confidence confidenceValue : confidenceValues) {
                if (!confidenceValue.getType().equalsIgnoreCase(this.getScoreName())) continue;
                score = Double.parseDouble(confidenceValue.getValue());
            }
            if (score == null) {
                logger.error((Object)("No score for this interaction: " + eI.getId()));
            }
            scores[i] = score;
            ++i;
        }
        return scores;
    }

    public void saveScores() {
        this.fileName = "scores.txt";
        this.saveScores(this.fileName);
    }

    public void saveScores(String fileName) {
        if (this.getInteractionMapping() == null || this.interactionMapping.isEmpty()) {
            this.runService();
        }
        Map interactionMapping = this.getInteractionMapping();
        String delimiter = ",";
        logger.info((Object)("Saving scores in " + fileName + "..."));
        try {
            FileWriter fstream = new FileWriter(fileName);
            for (Integer mappingId : interactionMapping.keySet()) {
                EncoreInteraction eI = (EncoreInteraction)interactionMapping.get(mappingId);
                if (eI == null) continue;
                String score = null;
                for (Confidence confidenceValue : eI.getConfidenceValues()) {
                    if (!confidenceValue.getType().equalsIgnoreCase(this.getScoreName())) continue;
                    score = confidenceValue.getValue();
                }
                if (score != null) {
                    fstream.write(score);
                } else {
                    fstream.write("0");
                }
                fstream.write(delimiter);
                fstream.flush();
            }
            fstream.close();
        }
        catch (Exception e) {
            logger.error((Object)("It is not possible to write the results in the file " + fileName));
            e.printStackTrace();
        }
    }

    public Map<String, Float> getCustomOntologyTypeScores() {
        return this.customOntologyTypeScores;
    }

    public void setCustomOntologyTypeScores(Map<String, Float> customOntologyTypeScores) {
        this.customOntologyTypeScores = customOntologyTypeScores;
    }

    public Map<String, Float> getCustomOntologyMethodScores() {
        return this.customOntologyMethodScores;
    }

    public void setCustomOntologyMethodScores(Map<String, Float> customOntologyMethodScores) {
        this.customOntologyMethodScores = customOntologyMethodScores;
    }

    public Integer getCustomPublicationNumberWithHighestScore() {
        return this.customPublicationNumberWithHighestScore;
    }

    public void setCustomPublicationNumberWithHighestScore(Integer publicationNumberWithHighestScore) {
        this.customPublicationNumberWithHighestScore = publicationNumberWithHighestScore;
    }

    public Float getTypeWeight() {
        return this.typeWeight;
    }

    public void setTypeWeight(Float typeWeight) {
        this.typeWeight = typeWeight;
    }

    public Float getMethodWeight() {
        return this.methodWeight;
    }

    public void setMethodWeight(Float methodWeight) {
        this.methodWeight = methodWeight;
    }

    public Float getPublicationWeight() {
        return this.publicationWeight;
    }

    public void setPublicationWeight(Float publicationWeight) {
        this.publicationWeight = publicationWeight;
    }

    public MIScore getMiscore() {
        return this.miscore;
    }

    public void setMiscore(MIScore miscore) {
        this.miscore = miscore;
    }

    public String getScoreName() {
        return this.scoreName;
    }

    public void setScoreName(String scoreName) {
        this.scoreName = scoreName;
    }
}

