/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.model.Alias;
import psidev.psi.mi.tab.model.AliasImpl;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.BinaryInteractionImpl;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.CrossReferenceImpl;
import psidev.psi.mi.tab.model.InteractionDetectionMethod;
import psidev.psi.mi.tab.model.InteractionDetectionMethodImpl;
import psidev.psi.mi.tab.model.InteractionType;
import psidev.psi.mi.tab.model.InteractionTypeImpl;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.OrganismImpl;
import uk.ac.ebi.enfin.mi.cluster.EncoreBinaryInteraction;
import uk.ac.ebi.enfin.mi.cluster.EncoreInteraction;
import uk.ac.ebi.enfin.mi.cluster.MethodTypePair;
import uk.ac.ebi.enfin.mi.score.ols.MIOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encore2Binary {
    private static final Log log = LogFactory.getLog(Encore2Binary.class);
    private Map<String, String> miMethodOntologyTerms;
    private Map<String, String> miTypeOntologyTerms;
    protected String mappingIdDbNames;

    public Encore2Binary(String mappingIdDbNames) {
        MIOntology olsHelper = new MIOntology();
        this.miMethodOntologyTerms = olsHelper.getJsonChildren("MI:0001");
        this.miTypeOntologyTerms = olsHelper.getJsonChildren("MI:0190");
        this.mappingIdDbNames = mappingIdDbNames;
    }

    public Encore2Binary() {
        MIOntology olsHelper = new MIOntology();
        this.miMethodOntologyTerms = olsHelper.getJsonChildren("MI:0001");
        this.miTypeOntologyTerms = olsHelper.getJsonChildren("MI:0190");
        this.mappingIdDbNames = null;
    }

    @Deprecated
    public BinaryInteraction getBinaryInteraction(EncoreBinaryInteraction encoreInteraction) {
        ArrayList<CrossReference> psiIdentifierA = new ArrayList<CrossReference>();
        ArrayList<CrossReference> psiAlternativeIdentifierA = new ArrayList<CrossReference>();
        String encoreInteractorA = encoreInteraction.getInteractorA(this.mappingIdDbNames);
        Map<String, String> encoreInteractorAccsA = encoreInteraction.getInteractorAccsA();
        this.updateIdentifiers(psiIdentifierA, psiAlternativeIdentifierA, encoreInteractorAccsA, encoreInteractorA);
        ArrayList<CrossReference> psiIdentifierB = new ArrayList<CrossReference>();
        ArrayList<CrossReference> psiAlternativeIdentifierB = new ArrayList<CrossReference>();
        String encoreInteractorB = encoreInteraction.getInteractorB(this.mappingIdDbNames);
        Map<String, String> encoreInteractorAccsB = encoreInteraction.getInteractorAccsB();
        this.updateIdentifiers(psiIdentifierB, psiAlternativeIdentifierB, encoreInteractorAccsB, encoreInteractorB);
        ArrayList<Alias> psiAliasA = new ArrayList<Alias>();
        Map<String, List<String>> encoreOtherInteractorA = encoreInteraction.getOtherInteractorAccsA();
        this.updateAlias(psiAliasA, encoreOtherInteractorA);
        ArrayList<Alias> psiAliasB = new ArrayList<Alias>();
        Map<String, List<String>> encoreOtherInteractorB = encoreInteraction.getOtherInteractorAccsB();
        this.updateAlias(psiAliasB, encoreOtherInteractorB);
        OrganismImpl psiOrganismA = new OrganismImpl();
        psiOrganismA.setIdentifiers(encoreInteraction.getOrganismsA());
        OrganismImpl psiOrganismB = new OrganismImpl();
        psiOrganismB.setIdentifiers(encoreInteraction.getOrganismsB());
        Interactor psiInteractorA = new Interactor();
        psiInteractorA.setIdentifiers(psiIdentifierA);
        psiInteractorA.setAlternativeIdentifiers(psiAlternativeIdentifierA);
        psiInteractorA.setAliases(psiAliasA);
        psiInteractorA.setOrganism(psiOrganismA);
        Interactor psiInteractorB = new Interactor();
        psiInteractorB.setIdentifiers(psiIdentifierB);
        psiInteractorB.setAlternativeIdentifiers(psiAlternativeIdentifierB);
        psiInteractorB.setAliases(psiAliasB);
        psiInteractorB.setOrganism(psiOrganismB);
        ArrayList<InteractionDetectionMethod> psiDetectionMethods = new ArrayList<InteractionDetectionMethod>();
        for (String methodId : encoreInteraction.getMethodToPubmed().keySet()) {
            InteractionDetectionMethodImpl psiDetectionMethod = new InteractionDetectionMethodImpl();
            psiDetectionMethod.setIdentifier(methodId);
            if (this.miMethodOntologyTerms.containsKey(methodId)) {
                psiDetectionMethod.setText(this.miMethodOntologyTerms.get(methodId));
                psiDetectionMethod.setDatabase("psi-mi");
            }
            psiDetectionMethods.add(psiDetectionMethod);
        }
        ArrayList<InteractionType> psiInteractionTypes = new ArrayList<InteractionType>();
        for (String typeId : encoreInteraction.getTypeToPubmed().keySet()) {
            InteractionTypeImpl psiInteractionType = new InteractionTypeImpl();
            psiInteractionType.setIdentifier(typeId);
            if (this.miTypeOntologyTerms.containsKey(typeId)) {
                psiInteractionType.setText(this.miTypeOntologyTerms.get(typeId));
                psiInteractionType.setDatabase("psi-mi");
            }
            psiInteractionTypes.add(psiInteractionType);
        }
        ArrayList<CrossReference> interactionAcs = new ArrayList<CrossReference>();
        Map<String, List<String>> experimentToDatabase = encoreInteraction.getExperimentToDatabase();
        if (experimentToDatabase != null) {
            for (String expAc : experimentToDatabase.keySet()) {
                if (expAc == null || expAc.length() == 0) {
                    log.warn((Object)("Could not process experimentAc (" + (expAc == null ? "null" : "'" + expAc + "'") + ") of EncoreInteraction(id=" + encoreInteraction.getId() + ") as it is null or empty "));
                    continue;
                }
                List<String> expDbs = experimentToDatabase.get(expAc);
                if (expDbs == null) continue;
                for (String expDb : expDbs) {
                    CrossReferenceImpl interactionAc = new CrossReferenceImpl(expDb, expAc);
                    interactionAcs.add(interactionAc);
                }
            }
        }
        BinaryInteractionImpl bI = new BinaryInteractionImpl(psiInteractorA, psiInteractorB);
        bI.setAuthors(encoreInteraction.getAuthors());
        bI.setInteractionAcs(interactionAcs);
        bI.setSourceDatabases(encoreInteraction.getSourceDatabases());
        bI.setConfidenceValues(encoreInteraction.getConfidenceValues());
        bI.setDetectionMethods(psiDetectionMethods);
        bI.setInteractionTypes(psiInteractionTypes);
        bI.setPublications(encoreInteraction.getPublicationIds());
        return bI;
    }

    public BinaryInteraction getBinaryInteractionForScoring(EncoreInteraction encoreInteraction) {
        ArrayList<CrossReference> psiIdentifierA = new ArrayList<CrossReference>();
        ArrayList<CrossReference> psiAlternativeIdentifierA = new ArrayList<CrossReference>();
        String encoreInteractorA = encoreInteraction.getInteractorA(this.mappingIdDbNames);
        Map<String, String> encoreInteractorAccsA = encoreInteraction.getInteractorAccsA();
        this.updateIdentifiers(psiIdentifierA, psiAlternativeIdentifierA, encoreInteractorAccsA, encoreInteractorA);
        ArrayList<CrossReference> psiIdentifierB = new ArrayList<CrossReference>();
        ArrayList<CrossReference> psiAlternativeIdentifierB = new ArrayList<CrossReference>();
        String encoreInteractorB = encoreInteraction.getInteractorB(this.mappingIdDbNames);
        Map<String, String> encoreInteractorAccsB = encoreInteraction.getInteractorAccsB();
        this.updateIdentifiers(psiIdentifierB, psiAlternativeIdentifierB, encoreInteractorAccsB, encoreInteractorB);
        ArrayList<Alias> psiAliasA = new ArrayList<Alias>();
        Map<String, List<String>> encoreOtherInteractorA = encoreInteraction.getOtherInteractorAccsA();
        this.updateAlias(psiAliasA, encoreOtherInteractorA);
        ArrayList<Alias> psiAliasB = new ArrayList<Alias>();
        Map<String, List<String>> encoreOtherInteractorB = encoreInteraction.getOtherInteractorAccsB();
        this.updateAlias(psiAliasB, encoreOtherInteractorB);
        OrganismImpl psiOrganismA = new OrganismImpl();
        psiOrganismA.setIdentifiers(encoreInteraction.getOrganismsA());
        OrganismImpl psiOrganismB = new OrganismImpl();
        psiOrganismB.setIdentifiers(encoreInteraction.getOrganismsB());
        Interactor psiInteractorA = new Interactor();
        psiInteractorA.setIdentifiers(psiIdentifierA);
        psiInteractorA.setAlternativeIdentifiers(psiAlternativeIdentifierA);
        psiInteractorA.setAliases(psiAliasA);
        psiInteractorA.setOrganism(psiOrganismA);
        Interactor psiInteractorB = new Interactor();
        psiInteractorB.setIdentifiers(psiIdentifierB);
        psiInteractorB.setAlternativeIdentifiers(psiAlternativeIdentifierB);
        psiInteractorB.setAliases(psiAliasB);
        psiInteractorB.setOrganism(psiOrganismB);
        ArrayList<InteractionDetectionMethod> psiDetectionMethods = new ArrayList<InteractionDetectionMethod>();
        ArrayList<InteractionType> psiInteractionTypes = new ArrayList<InteractionType>();
        for (MethodTypePair pair : encoreInteraction.getMethodTypePairListMap().keySet()) {
            Collection pubmedIds = encoreInteraction.getMethodTypePairListMap().get(pair);
            for (String pubmed : pubmedIds) {
                if (pair.getMethod() != null) {
                    InteractionDetectionMethodImpl psiDetectionMethod = new InteractionDetectionMethodImpl();
                    psiDetectionMethod.setIdentifier(pair.getMethod());
                    if (this.miMethodOntologyTerms.containsKey(pair.getMethod())) {
                        psiDetectionMethod.setText(this.miMethodOntologyTerms.get(pair.getMethod()));
                        psiDetectionMethod.setDatabase("psi-mi");
                    }
                    psiDetectionMethods.add(psiDetectionMethod);
                }
                if (pair.getType() == null) continue;
                InteractionTypeImpl psitype = new InteractionTypeImpl();
                psitype.setIdentifier(pair.getMethod());
                if (this.miTypeOntologyTerms.containsKey(pair.getType())) {
                    psitype.setText(this.miTypeOntologyTerms.get(pair.getType()));
                    psitype.setDatabase("psi-mi");
                }
                psiInteractionTypes.add(psitype);
            }
        }
        ArrayList<CrossReference> interactionAcs = new ArrayList<CrossReference>();
        Map<String, List<String>> experimentToDatabase = encoreInteraction.getExperimentToDatabase();
        if (experimentToDatabase != null) {
            for (String expAc : experimentToDatabase.keySet()) {
                if (expAc == null || expAc.length() == 0) {
                    log.warn((Object)("Could not process experimentAc (" + (expAc == null ? "null" : "'" + expAc + "'") + ") of EncoreInteraction(id=" + encoreInteraction.getId() + ") as it is null or empty "));
                    continue;
                }
                List<String> expDbs = experimentToDatabase.get(expAc);
                if (expDbs == null) continue;
                for (String expDb : expDbs) {
                    CrossReferenceImpl interactionAc = new CrossReferenceImpl(expDb, expAc);
                    interactionAcs.add(interactionAc);
                }
            }
        }
        BinaryInteractionImpl bI = new BinaryInteractionImpl(psiInteractorA, psiInteractorB);
        bI.setAuthors(encoreInteraction.getAuthors());
        bI.setInteractionAcs(interactionAcs);
        bI.setSourceDatabases(encoreInteraction.getSourceDatabases());
        bI.setConfidenceValues(encoreInteraction.getConfidenceValues());
        bI.setDetectionMethods(psiDetectionMethods);
        bI.setInteractionTypes(psiInteractionTypes);
        bI.setPublications(encoreInteraction.getPublicationIds());
        return bI;
    }

    private void updateIdentifiers(Collection<CrossReference> psiIdentifier, Collection<CrossReference> psiAlternativeIdentifier, Map<String, String> encoreInteractors, String encoreInteractor) {
        for (String db : encoreInteractors.keySet()) {
            CrossReferenceImpl pI;
            String acc = encoreInteractors.get(db);
            if (acc == encoreInteractor) {
                pI = new CrossReferenceImpl(db, acc);
                psiIdentifier.add(pI);
                continue;
            }
            pI = new CrossReferenceImpl(db, acc);
            psiAlternativeIdentifier.add(pI);
        }
    }

    private void updateAlias(Collection<Alias> psiAlias, Map<String, List<String>> encoreOtherInteractor) {
        for (String db : encoreOtherInteractor.keySet()) {
            List<String> accs = encoreOtherInteractor.get(db);
            for (String acc : accs) {
                AliasImpl pA = new AliasImpl(db, acc);
                psiAlias.add(pA);
            }
        }
    }
}

