/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.enfin.mi.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import psidev.psi.mi.tab.model.Author;
import psidev.psi.mi.tab.model.Confidence;
import psidev.psi.mi.tab.model.CrossReference;
import uk.ac.ebi.enfin.mi.cluster.EncoreBinaryInteraction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEncoreInteraction
implements EncoreBinaryInteraction {
    static Logger logger = Logger.getLogger(AbstractEncoreInteraction.class);
    protected int id;
    protected Map<String, String> interactorAccsA = new HashMap<String, String>();
    protected Map<String, String> interactorAccsB = new HashMap<String, String>();
    protected List<CrossReference> publicationIds = new ArrayList<CrossReference>();
    protected Map<String, String> experimentToPubmed = new HashMap<String, String>();
    protected Map<String, List<String>> experimentToDatabase = new HashMap<String, List<String>>();
    protected List<Confidence> confidenceValues = new ArrayList<Confidence>();
    protected List<Author> authors = new ArrayList<Author>();
    protected List<CrossReference> sourceDatabases = new ArrayList<CrossReference>();
    protected Collection<CrossReference> organismsA = new ArrayList<CrossReference>();
    protected Collection<CrossReference> organismsB = new ArrayList<CrossReference>();
    protected Map<String, List<String>> otherInteractorAccsA = new HashMap<String, List<String>>();
    protected Map<String, List<String>> otherInteractorAccsB = new HashMap<String, List<String>>();
    protected String mappingIdDbNames = "uniprotkb,irefindex,ddbj/embl/genbank,refseq,chebi";
    protected Map<String, List<String>> methodToPubmed = new HashMap<String, List<String>>();
    protected Map<String, List<String>> typeToPubmed = new HashMap<String, List<String>>();

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Map<String, String> getInteractorAccsA() {
        return this.interactorAccsA;
    }

    @Override
    public void setInteractorAccsA(Map<String, String> interactorAccsA) {
        this.interactorAccsA = interactorAccsA;
    }

    @Override
    public void addInteractorAccsA(Map<String, String> interactorAccsA) {
        for (String dbName : interactorAccsA.keySet()) {
            String acc = interactorAccsA.get(dbName);
            this.addInteractorAccsA(dbName, acc);
        }
    }

    @Override
    public void addInteractorAccsA(String dbName, String acc) {
        if (!this.interactorAccsA.containsKey(dbName)) {
            this.interactorAccsA.put(dbName, acc);
        }
    }

    @Override
    public Map<String, List<String>> getOtherInteractorAccsA() {
        return this.otherInteractorAccsA;
    }

    @Override
    public void setOtherInteractorAccsA(Map<String, List<String>> otherInteractorAccsA) {
        this.otherInteractorAccsA = otherInteractorAccsA;
    }

    @Override
    public void addOtherInteractorAccsA(Map<String, List<String>> otherInteractorAccsA) {
        this.otherInteractorAccsA = this.setMapping(this.otherInteractorAccsA, otherInteractorAccsA);
    }

    @Override
    public void addOtherInteractorAccsA(String dbName, String acc) {
        this.otherInteractorAccsA = this.setMapping(this.otherInteractorAccsA, dbName, acc);
    }

    @Override
    public Map<String, String> getInteractorAccsB() {
        return this.interactorAccsB;
    }

    @Override
    public void setInteractorAccsB(Map<String, String> interactorAccsB) {
        this.interactorAccsB = interactorAccsB;
    }

    @Override
    public void addInteractorAccsB(Map<String, String> interactorAccsB) {
        for (String dbName : interactorAccsB.keySet()) {
            String acc = interactorAccsB.get(dbName);
            this.addInteractorAccsB(dbName, acc);
        }
    }

    @Override
    public void addInteractorAccsB(String dbName, String acc) {
        if (!this.interactorAccsB.containsKey(dbName)) {
            this.interactorAccsB.put(dbName, acc);
        }
    }

    @Override
    public Map<String, List<String>> getOtherInteractorAccsB() {
        return this.otherInteractorAccsB;
    }

    @Override
    public void setOtherInteractorAccsB(Map<String, List<String>> otherInteractorAccsB) {
        this.otherInteractorAccsB = otherInteractorAccsB;
    }

    @Override
    public void addOtherInteractorAccsB(Map<String, List<String>> otherInteractorAccsB) {
        this.otherInteractorAccsB = this.setMapping(this.otherInteractorAccsB, otherInteractorAccsB);
    }

    @Override
    public void addOtherInteractorAccsB(String dbName, String acc) {
        this.otherInteractorAccsB = this.setMapping(this.otherInteractorAccsB, dbName, acc);
    }

    @Override
    public String getInteractorA() {
        return this.getInteractorA(this.mappingIdDbNames);
    }

    @Override
    public String getInteractorA(String mappingIdDbNames) {
        if (mappingIdDbNames == null) {
            mappingIdDbNames = this.mappingIdDbNames;
        }
        String acc = this.getInteractorFromAccs(this.interactorAccsA, mappingIdDbNames.split(","));
        return acc;
    }

    @Override
    public String getInteractorB() {
        return this.getInteractorB(this.mappingIdDbNames);
    }

    @Override
    public String getInteractorB(String mappingIdDbNames) {
        if (mappingIdDbNames == null) {
            mappingIdDbNames = this.mappingIdDbNames;
        }
        String acc = this.getInteractorFromAccs(this.interactorAccsB, mappingIdDbNames.split(","));
        return acc;
    }

    @Override
    public List<CrossReference> getPublicationIds() {
        return this.publicationIds;
    }

    @Override
    public void setPublicationIds(List<CrossReference> publicationIds) {
        this.publicationIds = publicationIds;
    }

    @Override
    public void addPublicationId(CrossReference publicationId) {
        if (!this.publicationIds.contains(publicationId)) {
            this.publicationIds.add(publicationId);
        }
    }

    @Override
    public void addPublicationId(List<CrossReference> publicationIds) {
        for (CrossReference publicationId : publicationIds) {
            this.addPublicationId(publicationId);
        }
    }

    @Override
    public Map<String, String> getExperimentToPubmed() {
        return this.experimentToPubmed;
    }

    @Override
    public void setExperimentToPubmed(Map<String, String> experimentToPubmed) {
        this.experimentToPubmed = experimentToPubmed;
    }

    @Override
    public void addExperimentToPubmed(Map<String, String> experimentToPubmed) {
        for (String experiment : experimentToPubmed.keySet()) {
            String pubmed = experimentToPubmed.get(experiment);
            this.addExperimentToPubmed(experiment, pubmed);
        }
    }

    @Override
    public void addExperimentToPubmed(String experiment, String pubmed) {
        if (!this.experimentToPubmed.containsKey(experiment)) {
            this.experimentToPubmed.put(experiment, pubmed);
        }
    }

    @Override
    public Map<String, List<String>> getExperimentToDatabase() {
        return this.experimentToDatabase;
    }

    @Override
    public void setExperimentToDatabase(Map<String, List<String>> experimentToDatabase) {
        this.experimentToDatabase = experimentToDatabase;
    }

    @Override
    public void addExperimentToDatabase(Map<String, List<String>> experimentToDatabase) {
        this.experimentToDatabase = this.setMapping(this.experimentToDatabase, experimentToDatabase);
    }

    @Override
    public void addExperimentToDatabase(String experiment, String database) {
        this.experimentToDatabase = this.setMapping(this.experimentToDatabase, experiment, database);
    }

    @Override
    public List<Confidence> getConfidenceValues() {
        return this.confidenceValues;
    }

    @Override
    public void setConfidenceValues(List<Confidence> confidenceValues) {
        this.confidenceValues = confidenceValues;
    }

    @Override
    public void addConfidenceValues(List<Confidence> confidenceValues) {
        for (Confidence confidenceValue : confidenceValues) {
            this.addConfidenceValue(confidenceValue);
        }
    }

    @Override
    public void addConfidenceValue(Confidence confidenceValue) {
        if (!this.confidenceValues.contains(confidenceValue)) {
            this.confidenceValues.add(confidenceValue);
        }
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    @Override
    public void setAuthors(List<Author> authors) {
        this.authors = authors;
    }

    @Override
    public void addAuthors(List<Author> authors) {
        for (Author author : authors) {
            this.addAuthor(author);
        }
    }

    @Override
    public void addAuthor(Author author) {
        if (!this.authors.contains(author)) {
            this.authors.add(author);
        }
    }

    @Override
    public List<CrossReference> getSourceDatabases() {
        return this.sourceDatabases;
    }

    @Override
    public void setSourceDatabases(List<CrossReference> sourceDatabases) {
        this.sourceDatabases = sourceDatabases;
    }

    @Override
    public void addSourceDatabases(List<CrossReference> sourceDatabases) {
        for (CrossReference sourceDatabase : sourceDatabases) {
            this.addSourceDatabase(sourceDatabase);
        }
    }

    @Override
    public void addSourceDatabase(CrossReference sourceDatabase) {
        if (!this.sourceDatabases.contains(sourceDatabase)) {
            this.sourceDatabases.add(sourceDatabase);
        }
    }

    @Override
    public Collection<CrossReference> getOrganismsA() {
        return this.organismsA;
    }

    @Override
    public void setOrganismsA(Collection<CrossReference> organismsA) {
        this.organismsA = organismsA;
    }

    @Override
    public void addOrganismsA(Collection<CrossReference> organismsA) {
        for (CrossReference organismA : organismsA) {
            this.addOrganismA(organismA);
        }
    }

    @Override
    public void addOrganismA(CrossReference organismA) {
        if (!this.organismsA.contains(organismA)) {
            this.organismsA.add(organismA);
        }
    }

    @Override
    public Collection<CrossReference> getOrganismsB() {
        return this.organismsB;
    }

    @Override
    public void setOrganismsB(Collection<CrossReference> organismsB) {
        this.organismsB = organismsB;
    }

    @Override
    public void addOrganismsB(Collection<CrossReference> organismsB) {
        for (CrossReference organismB : organismsB) {
            this.addOrganismB(organismB);
        }
    }

    @Override
    public void addOrganismB(CrossReference organismB) {
        if (!this.organismsB.contains(organismB)) {
            this.organismsB.add(organismB);
        }
    }

    @Override
    public String getMappingIdDbNames() {
        return this.mappingIdDbNames;
    }

    @Override
    public void setMappingIdDbNames(String mappingIdDbNames) {
        this.mappingIdDbNames = mappingIdDbNames;
    }

    protected Map<String, List<String>> setMapping(Map<String, List<String>> originalList, Map<String, List<String>> query) {
        for (String key : query.keySet()) {
            List<String> values = query.get(key);
            for (String value : values) {
                originalList = this.setMapping(originalList, key, value);
            }
        }
        return originalList;
    }

    protected Map<String, List<String>> setMapping(Map<String, List<String>> originalList, String key, String value) {
        if (value != null && key != null) {
            HashMap<String, List<Object>> originalListTemp = new HashMap<String, List<Object>>();
            List<Object> pubmeds = new ArrayList<String>();
            if (originalList.containsKey(key)) {
                pubmeds = originalList.get(key);
                if (!originalList.get(key).contains(value)) {
                    pubmeds.add(value);
                    originalList.put(key, pubmeds);
                }
            } else {
                pubmeds.add(value);
                originalListTemp.put(key, pubmeds);
            }
            originalList.putAll(originalListTemp);
        } else {
            logger.warn((Object)"The value or key is null in setMapping");
        }
        return originalList;
    }

    protected String getInteractorFromAccs(Map<String, String> interactorAccs, String[] idDbNameList) {
        String interactorAcc = null;
        for (String idDbName : idDbNameList) {
            if (!interactorAccs.containsKey(idDbName)) continue;
            interactorAcc = interactorAccs.get(idDbName);
            break;
        }
        if (interactorAcc == null) {
            interactorAcc = interactorAccs.values().iterator().next();
        }
        return interactorAcc;
    }

    @Override
    public Map<String, List<String>> getMethodToPubmed() {
        return this.methodToPubmed;
    }

    public void setMethodToPubmed(Map<String, List<String>> methodToPubmed) {
        this.methodToPubmed = methodToPubmed;
    }

    public void addMethodToPubmed(String method, String pubmed) {
        this.methodToPubmed = this.setMapping(this.methodToPubmed, method, pubmed);
    }

    public void addMethodToPubmed(Map<String, List<String>> methodToPubmed) {
        this.methodToPubmed = this.setMapping(this.methodToPubmed, methodToPubmed);
    }

    @Override
    public Map<String, List<String>> getTypeToPubmed() {
        return this.typeToPubmed;
    }

    public void setTypeToPubmed(Map<String, List<String>> typeToPubmed) {
        this.typeToPubmed = typeToPubmed;
    }

    public void addTypeToPubmed(Map<String, List<String>> typeToPubmed) {
        this.typeToPubmed = this.setMapping(this.typeToPubmed, typeToPubmed);
    }

    public void addTypeToPubmed(String type, String pubmed) {
        this.typeToPubmed = this.setMapping(this.typeToPubmed, type, pubmed);
    }
}

