/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.dao.inMemory;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.model.HasId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryDAO<T extends HasId>
implements PsiDAO<T> {
    public static final Log log = LogFactory.getLog(InMemoryDAO.class);
    private Map<Integer, T> map = new HashMap<Integer, T>();

    InMemoryDAO() {
    }

    @Override
    public Collection<T> getAll() {
        return this.map.values();
    }

    @Override
    public T retreive(int id) {
        return (T)((HasId)this.map.get(id));
    }

    @Override
    public void store(T object) {
        if (object == null) {
            throw new IllegalArgumentException("The Object to store must not be null.");
        }
        String name = object.getClass().getSimpleName();
        int id = object.getId();
        if (this.map.containsKey(id)) {
            log.warn((Object)("Attempt to overwrite an existing " + name + " with id: " + id));
            HasId original = (HasId)this.map.get(id);
            if (!object.equals(original)) {
                log.error((Object)("The new " + name + " was different"));
                log.error((Object)("Original : " + original));
                log.error((Object)("New : " + object));
                throw new IllegalArgumentException("Attemp to overwrite " + name + " having id:" + id + ") with a different " + name + " of the same type.");
            }
            log.warn((Object)("The " + name + " to store was the same."));
        }
        log.info((Object)("Storing " + name + " under key( " + id + " )"));
        this.map.put(id, object);
    }

    @Override
    public T remove(int id) {
        return (T)((HasId)this.map.remove(id));
    }

    @Override
    public void reset() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing inMemory DAO map: " + this.getClass().getSimpleName()));
        }
        this.map.clear();
    }
}

