/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter.impl253;

import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.impl253.AttributeConverter;
import psidev.psi.mi.xml.converter.impl253.CvTypeConverter;
import psidev.psi.mi.xml.converter.impl253.NamesConverter;
import psidev.psi.mi.xml.converter.impl253.OrganismConverter;
import psidev.psi.mi.xml.converter.impl253.XrefConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorType;
import psidev.psi.mi.xml253.jaxb.AttributeListType;
import psidev.psi.mi.xml253.jaxb.BioSourceType;
import psidev.psi.mi.xml253.jaxb.InteractorElementType;

public class InteractorConverter {
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private OrganismConverter organismConverter = new OrganismConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Interactor fromJaxb(InteractorElementType jInteractor) throws ConverterException {
        String sequence;
        if (jInteractor == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Interactor.");
        }
        this.checkDependencies();
        Interactor mInteractor = new Interactor();
        mInteractor.setId(jInteractor.getId());
        mInteractor.setInteractorType(this.cvTypeConverter.fromJaxb(jInteractor.getInteractorType(), InteractorType.class));
        if (jInteractor.getNames() != null) {
            mInteractor.setNames(this.namesConverter.fromJaxb(jInteractor.getNames()));
        }
        if (jInteractor.getXref() != null) {
            mInteractor.setXref(this.xrefConverter.fromJaxb(jInteractor.getXref()));
        }
        if (jInteractor.getOrganism() != null) {
            mInteractor.setOrganism(this.organismConverter.fromJaxb((BioSourceType)jInteractor.getOrganism()));
        }
        if ((sequence = jInteractor.getSequence()) != null) {
            sequence = sequence.trim();
        }
        mInteractor.setSequence(sequence);
        if (jInteractor.getAttributeList() != null) {
            for (AttributeListType.Attribute attribute : jInteractor.getAttributeList().getAttributes()) {
                mInteractor.getAttributes().add(this.attributeConverter.fromJaxb(attribute));
            }
        }
        PsiDAO<Interactor> interactorDAO = this.factory.getInteractorDAO();
        interactorDAO.store(mInteractor);
        return mInteractor;
    }

    public InteractorElementType toJaxb(Interactor mInteractor) throws ConverterException {
        String sequence;
        if (mInteractor == null) {
            throw new IllegalArgumentException("You must give a non null model Interactor.");
        }
        this.checkDependencies();
        InteractorElementType jInteractor = new InteractorElementType();
        jInteractor.setId(mInteractor.getId());
        jInteractor.setInteractorType(this.cvTypeConverter.toJaxb(mInteractor.getInteractorType()));
        if (mInteractor.getNames() != null) {
            jInteractor.setNames(this.namesConverter.toJaxb(mInteractor.getNames()));
        }
        if (mInteractor.hasXref()) {
            jInteractor.setXref(this.xrefConverter.toJaxb(mInteractor.getXref()));
        }
        if (mInteractor.hasOrganism()) {
            jInteractor.setOrganism(this.organismConverter.toJaxb(mInteractor.getOrganism(), InteractorElementType.Organism.class));
        }
        if ((sequence = mInteractor.getSequence()) != null) {
            sequence = sequence.trim();
        }
        jInteractor.setSequence(sequence);
        if (mInteractor.hasAttributes()) {
            jInteractor.setAttributeList(new AttributeListType());
            for (Attribute attribute : mInteractor.getAttributes()) {
                jInteractor.getAttributeList().getAttributes().add(this.attributeConverter.toJaxb(attribute));
            }
        }
        return jInteractor;
    }
}

