/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.PsimiTabReader;
import psidev.psi.mi.tab.PsimiTabWriter;
import psidev.psi.mi.tab.converter.txt2tab.behaviour.IgnoreAndPrintUnparseableLine;
import psidev.psi.mi.tab.converter.txt2tab.behaviour.UnparseableLineBehaviour;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.processor.ClusterInteractorPairProcessor;
import psidev.psi.mi.xml.converter.ConverterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsimiTabFileMerger {
    public static final Log log = LogFactory.getLog(PsimiTabFileMerger.class);

    public static Collection<BinaryInteraction> merge(Collection<File> inputFiles, UnparseableLineBehaviour unparseableLineBehaviour) throws ConverterException, IOException {
        for (File inputFile : inputFiles) {
            if (!inputFile.exists()) {
                throw new IllegalArgumentException("File does not exist: " + inputFile.getAbsolutePath());
            }
            if (inputFile.canRead()) continue;
            throw new IllegalArgumentException("File not readable: " + inputFile.getAbsolutePath());
        }
        long start = System.currentTimeMillis();
        Collection<BinaryInteraction> all = new ArrayList<BinaryInteraction>(1024);
        PsimiTabReader reader = new PsimiTabReader(true);
        reader.setUnparseableLineBehaviour(unparseableLineBehaviour);
        for (File inputFile : inputFiles) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading " + inputFile.getAbsolutePath()));
            }
            all.addAll(reader.read(inputFile));
        }
        if (!all.isEmpty()) {
            log.debug((Object)"Clustering...");
            ClusterInteractorPairProcessor<BinaryInteraction> cipp = new ClusterInteractorPairProcessor<BinaryInteraction>();
            all = cipp.process(all);
        } else {
            System.out.println("No interaction to merge.");
        }
        if (log.isDebugEnabled()) {
            long stop = System.currentTimeMillis();
            log.debug((Object)("Time elapsed: " + (stop - start) + "ms"));
        }
        return all;
    }

    public static Collection<BinaryInteraction> merge(Collection<File> inputFiles) throws ConverterException, IOException {
        return PsimiTabFileMerger.merge(inputFiles, new IgnoreAndPrintUnparseableLine(System.err));
    }

    public static void merge(Collection<File> inputFiles, File output, UnparseableLineBehaviour unparseableLineBehaviour) throws ConverterException, IOException {
        for (File inputFile : inputFiles) {
            if (!inputFile.exists()) {
                throw new IllegalArgumentException("File does not exist: " + inputFile.getAbsolutePath());
            }
            if (inputFile.canRead()) continue;
            throw new IllegalArgumentException("File not readable: " + inputFile.getAbsolutePath());
        }
        if (output.exists() && !output.canWrite()) {
            throw new IllegalArgumentException("Cannot write file: " + output.getAbsolutePath());
        }
        long start = System.currentTimeMillis();
        ArrayList<BinaryInteraction> all = new ArrayList<BinaryInteraction>(1024);
        PsimiTabReader reader = new PsimiTabReader(true);
        reader.setUnparseableLineBehaviour(unparseableLineBehaviour);
        for (File inputFile : inputFiles) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading " + inputFile.getAbsolutePath()));
            }
            all.addAll(reader.read(inputFile));
        }
        if (!all.isEmpty()) {
            log.debug((Object)"Clustering...");
            ClusterInteractorPairProcessor<BinaryInteraction> cipp = new ClusterInteractorPairProcessor<BinaryInteraction>();
            Collection<BinaryInteraction> allClustered = cipp.process(all);
            log.debug((Object)"Writing result on disk...");
            PsimiTabWriter writer = new PsimiTabWriter();
            writer.setHeaderEnabled(true);
            writer.write(allClustered, output);
        } else {
            System.out.println("No interaction to merge.");
        }
        if (log.isDebugEnabled()) {
            long stop = System.currentTimeMillis();
            log.debug((Object)("Time elapsed: " + (stop - start) + "ms"));
        }
    }

    public static void merge(Collection<File> inputFiles, File output) throws ConverterException, IOException {
        PsimiTabFileMerger.merge(inputFiles, output, new IgnoreAndPrintUnparseableLine(System.err));
    }

    public static void main(String[] args) throws ConverterException, IOException {
        ArrayList<File> inputs = new ArrayList<File>(1);
        inputs.add(new File("C:\\MITAB25\\2007-02-02-MINT.sam.txt"));
        PsimiTabFileMerger.merge(inputs, new File("C:\\MITAB25\\mint_clustered.txt"));
    }
}

