/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.utils;

import java.util.ArrayList;
import java.util.Collection;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.tab.model.OrganismImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinaryInteractionHandler<T extends BinaryInteraction> {
    public abstract T newBinaryInteraction(Interactor var1, Interactor var2);

    public abstract Interactor newInteractor(Collection<CrossReference> var1);

    public T merge(T bi1, T bi2) {
        Interactor merged = this.cloneBinaryInteraction(bi1);
        merged.setInteractorA((Interactor)this.mergeInteractorA((Interactor)bi1.getInteractorA(), (Interactor)bi2.getInteractorA()));
        merged.setInteractorB((Interactor)this.mergeInteractorB((Interactor)bi1.getInteractorB(), (Interactor)bi2.getInteractorB()));
        this.populateBinaryInteraction(bi2, merged);
        return (T)merged;
    }

    public T cloneBinaryInteraction(T interaction) {
        T clone = this.newBinaryInteraction(this.cloneInteractor((Interactor)interaction.getInteractorA()), this.cloneInteractor((Interactor)interaction.getInteractorB()));
        this.populateBinaryInteraction(interaction, clone);
        return clone;
    }

    protected void populateBinaryInteraction(T source, T target) {
        target.getPublications().addAll(source.getPublications());
        target.getAuthors().addAll(source.getAuthors());
        target.getInteractionTypes().addAll(source.getInteractionTypes());
        target.getDetectionMethods().addAll(source.getDetectionMethods());
        target.getConfidenceValues().addAll(source.getConfidenceValues());
        target.getSourceDatabases().addAll(source.getSourceDatabases());
        target.getInteractionAcs().addAll(source.getInteractionAcs());
    }

    protected Interactor mergeInteractorA(Interactor i1, Interactor i2) {
        return this.mergeInteractors(i1, i2);
    }

    protected Interactor mergeInteractorB(Interactor i1, Interactor i2) {
        return this.mergeInteractors(i1, i2);
    }

    protected Interactor mergeInteractors(Interactor i1, Interactor i2) {
        Interactor merged = this.cloneInteractor(i1);
        merged.getIdentifiers().addAll(i2.getIdentifiers());
        this.populateInteractor(i2, merged);
        return merged;
    }

    public Interactor cloneInteractor(Interactor interactor) {
        Interactor clone = this.newInteractor(new ArrayList<CrossReference>(interactor.getIdentifiers()));
        this.populateInteractor(interactor, clone);
        return clone;
    }

    protected void populateInteractor(Interactor source, Interactor target) {
        target.getAlternativeIdentifiers().addAll(source.getAlternativeIdentifiers());
        target.getAliases().addAll(source.getAliases());
        if (!target.hasOrganism()) {
            target.setOrganism(new OrganismImpl());
        }
        if (source.hasOrganism()) {
            target.getOrganism().getIdentifiers().addAll(source.getOrganism().getIdentifiers());
        }
    }
}

